/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ilm;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ilm.LifecycleAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class SearchableSnapshotAction
implements LifecycleAction,
ToXContentObject {
    public static final String NAME = "searchable_snapshot";
    public static final ParseField SNAPSHOT_REPOSITORY = new ParseField("snapshot_repository", new String[0]);
    public static final ParseField FORCE_MERGE_INDEX = new ParseField("force_merge_index", new String[0]);
    private static final ConstructingObjectParser<SearchableSnapshotAction, Void> PARSER = new ConstructingObjectParser("searchable_snapshot", true, a -> new SearchableSnapshotAction((String)a[0], a[1] == null || (Boolean)a[1] != false));
    private final String snapshotRepository;
    private final boolean forceMergeIndex;

    public static SearchableSnapshotAction parse(XContentParser parser) {
        return (SearchableSnapshotAction)PARSER.apply(parser, null);
    }

    public SearchableSnapshotAction(String snapshotRepository, boolean forceMergeIndex) {
        if (!Strings.hasText((String)snapshotRepository)) {
            throw new IllegalArgumentException("the snapshot repository must be specified");
        }
        this.snapshotRepository = snapshotRepository;
        this.forceMergeIndex = forceMergeIndex;
    }

    public SearchableSnapshotAction(String snapshotRepository) {
        this(snapshotRepository, true);
    }

    boolean isForceMergeIndex() {
        return this.forceMergeIndex;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SNAPSHOT_REPOSITORY.getPreferredName(), this.snapshotRepository);
        builder.field(FORCE_MERGE_INDEX.getPreferredName(), this.forceMergeIndex);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchableSnapshotAction that = (SearchableSnapshotAction)o;
        return this.forceMergeIndex == that.forceMergeIndex && this.snapshotRepository.equals(that.snapshotRepository);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotRepository, this.forceMergeIndex);
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SNAPSHOT_REPOSITORY);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FORCE_MERGE_INDEX);
    }
}

