/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.common.TimeUtil;
import org.elasticsearch.client.ml.job.config.AnalysisConfig;
import org.elasticsearch.client.ml.job.config.AnalysisLimits;
import org.elasticsearch.client.ml.job.config.DataDescription;
import org.elasticsearch.client.ml.job.config.ModelPlotConfig;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.TimeValue;

public class Job
implements ToXContentObject {
    public static final String ANOMALY_DETECTOR_JOB_TYPE = "anomaly_detector";
    public static final ParseField ID = new ParseField("job_id", new String[0]);
    public static final ParseField JOB_TYPE = new ParseField("job_type", new String[0]);
    public static final ParseField GROUPS = new ParseField("groups", new String[0]);
    public static final ParseField ANALYSIS_CONFIG = AnalysisConfig.ANALYSIS_CONFIG;
    public static final ParseField ANALYSIS_LIMITS = new ParseField("analysis_limits", new String[0]);
    public static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    public static final ParseField CUSTOM_SETTINGS = new ParseField("custom_settings", new String[0]);
    public static final ParseField DATA_DESCRIPTION = new ParseField("data_description", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField FINISHED_TIME = new ParseField("finished_time", new String[0]);
    public static final ParseField MODEL_PLOT_CONFIG = new ParseField("model_plot_config", new String[0]);
    public static final ParseField RENORMALIZATION_WINDOW_DAYS = new ParseField("renormalization_window_days", new String[0]);
    public static final ParseField BACKGROUND_PERSIST_INTERVAL = new ParseField("background_persist_interval", new String[0]);
    public static final ParseField MODEL_SNAPSHOT_RETENTION_DAYS = new ParseField("model_snapshot_retention_days", new String[0]);
    public static final ParseField DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS = new ParseField("daily_model_snapshot_retention_after_days", new String[0]);
    public static final ParseField RESULTS_RETENTION_DAYS = new ParseField("results_retention_days", new String[0]);
    public static final ParseField MODEL_SNAPSHOT_ID = new ParseField("model_snapshot_id", new String[0]);
    public static final ParseField RESULTS_INDEX_NAME = new ParseField("results_index_name", new String[0]);
    public static final ParseField DELETING = new ParseField("deleting", new String[0]);
    public static final ParseField ALLOW_LAZY_OPEN = new ParseField("allow_lazy_open", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("job_details", true, () -> new Builder());
    private final String jobId;
    private final String jobType;
    private final List<String> groups;
    private final String description;
    private final Date createTime;
    private final Date finishedTime;
    private final AnalysisConfig analysisConfig;
    private final AnalysisLimits analysisLimits;
    private final DataDescription dataDescription;
    private final ModelPlotConfig modelPlotConfig;
    private final Long renormalizationWindowDays;
    private final TimeValue backgroundPersistInterval;
    private final Long modelSnapshotRetentionDays;
    private final Long dailyModelSnapshotRetentionAfterDays;
    private final Long resultsRetentionDays;
    private final Map<String, Object> customSettings;
    private final String modelSnapshotId;
    private final String resultsIndexName;
    private final Boolean deleting;
    private final Boolean allowLazyOpen;

    private Job(String jobId, String jobType, List<String> groups, String description, Date createTime, Date finishedTime, AnalysisConfig analysisConfig, AnalysisLimits analysisLimits, DataDescription dataDescription, ModelPlotConfig modelPlotConfig, Long renormalizationWindowDays, TimeValue backgroundPersistInterval, Long modelSnapshotRetentionDays, Long dailyModelSnapshotRetentionAfterDays, Long resultsRetentionDays, Map<String, Object> customSettings, String modelSnapshotId, String resultsIndexName, Boolean deleting, Boolean allowLazyOpen) {
        this.jobId = jobId;
        this.jobType = jobType;
        this.groups = Collections.unmodifiableList(groups);
        this.description = description;
        this.createTime = createTime;
        this.finishedTime = finishedTime;
        this.analysisConfig = analysisConfig;
        this.analysisLimits = analysisLimits;
        this.dataDescription = dataDescription;
        this.modelPlotConfig = modelPlotConfig;
        this.renormalizationWindowDays = renormalizationWindowDays;
        this.backgroundPersistInterval = backgroundPersistInterval;
        this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
        this.dailyModelSnapshotRetentionAfterDays = dailyModelSnapshotRetentionAfterDays;
        this.resultsRetentionDays = resultsRetentionDays;
        this.customSettings = customSettings == null ? null : Collections.unmodifiableMap(customSettings);
        this.modelSnapshotId = modelSnapshotId;
        this.resultsIndexName = resultsIndexName;
        this.deleting = deleting;
        this.allowLazyOpen = allowLazyOpen;
    }

    public String getId() {
        return this.jobId;
    }

    public String getJobType() {
        return this.jobType;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    private String getResultsIndexNameNoPrefix() {
        return this.resultsIndexName;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getFinishedTime() {
        return this.finishedTime;
    }

    public AnalysisConfig getAnalysisConfig() {
        return this.analysisConfig;
    }

    public AnalysisLimits getAnalysisLimits() {
        return this.analysisLimits;
    }

    public ModelPlotConfig getModelPlotConfig() {
        return this.modelPlotConfig;
    }

    public DataDescription getDataDescription() {
        return this.dataDescription;
    }

    public Long getRenormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    public TimeValue getBackgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    public Long getModelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    public Long getDailyModelSnapshotRetentionAfterDays() {
        return this.dailyModelSnapshotRetentionAfterDays;
    }

    public Long getResultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    public Map<String, Object> getCustomSettings() {
        return this.customSettings;
    }

    public String getModelSnapshotId() {
        return this.modelSnapshotId;
    }

    public Boolean getDeleting() {
        return this.deleting;
    }

    public Boolean getAllowLazyOpen() {
        return this.allowLazyOpen;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        String humanReadableSuffix = "_string";
        builder.field(ID.getPreferredName(), this.jobId);
        builder.field(JOB_TYPE.getPreferredName(), this.jobType);
        if (!this.groups.isEmpty()) {
            builder.field(GROUPS.getPreferredName(), this.groups);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.createTime != null) {
            builder.timeField(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.getTime());
        }
        if (this.finishedTime != null) {
            builder.timeField(FINISHED_TIME.getPreferredName(), FINISHED_TIME.getPreferredName() + "_string", this.finishedTime.getTime());
        }
        builder.field(ANALYSIS_CONFIG.getPreferredName(), (ToXContent)this.analysisConfig, params);
        if (this.analysisLimits != null) {
            builder.field(ANALYSIS_LIMITS.getPreferredName(), (ToXContent)this.analysisLimits, params);
        }
        if (this.dataDescription != null) {
            builder.field(DATA_DESCRIPTION.getPreferredName(), (ToXContent)this.dataDescription, params);
        }
        if (this.modelPlotConfig != null) {
            builder.field(MODEL_PLOT_CONFIG.getPreferredName(), (ToXContent)this.modelPlotConfig, params);
        }
        if (this.renormalizationWindowDays != null) {
            builder.field(RENORMALIZATION_WINDOW_DAYS.getPreferredName(), this.renormalizationWindowDays);
        }
        if (this.backgroundPersistInterval != null) {
            builder.field(BACKGROUND_PERSIST_INTERVAL.getPreferredName(), this.backgroundPersistInterval.getStringRep());
        }
        if (this.modelSnapshotRetentionDays != null) {
            builder.field(MODEL_SNAPSHOT_RETENTION_DAYS.getPreferredName(), this.modelSnapshotRetentionDays);
        }
        if (this.dailyModelSnapshotRetentionAfterDays != null) {
            builder.field(DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS.getPreferredName(), this.dailyModelSnapshotRetentionAfterDays);
        }
        if (this.resultsRetentionDays != null) {
            builder.field(RESULTS_RETENTION_DAYS.getPreferredName(), this.resultsRetentionDays);
        }
        if (this.customSettings != null) {
            builder.field(CUSTOM_SETTINGS.getPreferredName(), this.customSettings);
        }
        if (this.modelSnapshotId != null) {
            builder.field(MODEL_SNAPSHOT_ID.getPreferredName(), this.modelSnapshotId);
        }
        if (this.resultsIndexName != null) {
            builder.field(RESULTS_INDEX_NAME.getPreferredName(), this.resultsIndexName);
        }
        if (this.deleting != null) {
            builder.field(DELETING.getPreferredName(), this.deleting);
        }
        if (this.allowLazyOpen != null) {
            builder.field(ALLOW_LAZY_OPEN.getPreferredName(), this.allowLazyOpen);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Job that = (Job)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.jobType, that.jobType) && Objects.equals(this.groups, that.groups) && Objects.equals(this.description, that.description) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.finishedTime, that.finishedTime) && Objects.equals(this.analysisConfig, that.analysisConfig) && Objects.equals(this.analysisLimits, that.analysisLimits) && Objects.equals(this.dataDescription, that.dataDescription) && Objects.equals(this.modelPlotConfig, that.modelPlotConfig) && Objects.equals(this.renormalizationWindowDays, that.renormalizationWindowDays) && Objects.equals(this.backgroundPersistInterval, that.backgroundPersistInterval) && Objects.equals(this.modelSnapshotRetentionDays, that.modelSnapshotRetentionDays) && Objects.equals(this.dailyModelSnapshotRetentionAfterDays, that.dailyModelSnapshotRetentionAfterDays) && Objects.equals(this.resultsRetentionDays, that.resultsRetentionDays) && Objects.equals(this.customSettings, that.customSettings) && Objects.equals(this.modelSnapshotId, that.modelSnapshotId) && Objects.equals(this.resultsIndexName, that.resultsIndexName) && Objects.equals(this.deleting, that.deleting) && Objects.equals(this.allowLazyOpen, that.allowLazyOpen);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.jobType, this.groups, this.description, this.createTime, this.finishedTime, this.analysisConfig, this.analysisLimits, this.dataDescription, this.modelPlotConfig, this.renormalizationWindowDays, this.backgroundPersistInterval, this.modelSnapshotRetentionDays, this.dailyModelSnapshotRetentionAfterDays, this.resultsRetentionDays, this.customSettings, this.modelSnapshotId, this.resultsIndexName, this.deleting, this.allowLazyOpen);
    }

    public final String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    static {
        PARSER.declareString(Builder::setId, ID);
        PARSER.declareString(Builder::setJobType, JOB_TYPE);
        PARSER.declareStringArray(Builder::setGroups, GROUPS);
        PARSER.declareStringOrNull(Builder::setDescription, DESCRIPTION);
        PARSER.declareField(Builder::setCreateTime, p -> TimeUtil.parseTimeField(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(Builder::setFinishedTime, p -> TimeUtil.parseTimeField(p, FINISHED_TIME.getPreferredName()), FINISHED_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareObject(Builder::setAnalysisConfig, AnalysisConfig.PARSER, ANALYSIS_CONFIG);
        PARSER.declareObject(Builder::setAnalysisLimits, AnalysisLimits.PARSER, ANALYSIS_LIMITS);
        PARSER.declareObject(Builder::setDataDescription, DataDescription.PARSER, DATA_DESCRIPTION);
        PARSER.declareObject(Builder::setModelPlotConfig, ModelPlotConfig.PARSER, MODEL_PLOT_CONFIG);
        PARSER.declareLong(Builder::setRenormalizationWindowDays, RENORMALIZATION_WINDOW_DAYS);
        PARSER.declareString((builder, val) -> builder.setBackgroundPersistInterval(TimeValue.parseTimeValue((String)val, (String)BACKGROUND_PERSIST_INTERVAL.getPreferredName())), BACKGROUND_PERSIST_INTERVAL);
        PARSER.declareLong(Builder::setResultsRetentionDays, RESULTS_RETENTION_DAYS);
        PARSER.declareLong(Builder::setModelSnapshotRetentionDays, MODEL_SNAPSHOT_RETENTION_DAYS);
        PARSER.declareLong(Builder::setDailyModelSnapshotRetentionAfterDays, DAILY_MODEL_SNAPSHOT_RETENTION_AFTER_DAYS);
        PARSER.declareField(Builder::setCustomSettings, (p, c) -> p.mapOrdered(), CUSTOM_SETTINGS, ObjectParser.ValueType.OBJECT);
        PARSER.declareStringOrNull(Builder::setModelSnapshotId, MODEL_SNAPSHOT_ID);
        PARSER.declareString(Builder::setResultsIndexName, RESULTS_INDEX_NAME);
        PARSER.declareBoolean(Builder::setDeleting, DELETING);
        PARSER.declareBoolean(Builder::setAllowLazyOpen, ALLOW_LAZY_OPEN);
    }

    public static class Builder {
        private String id;
        private String jobType = "anomaly_detector";
        private List<String> groups = Collections.emptyList();
        private String description;
        private AnalysisConfig analysisConfig;
        private AnalysisLimits analysisLimits;
        private DataDescription dataDescription;
        private Date createTime;
        private Date finishedTime;
        private ModelPlotConfig modelPlotConfig;
        private Long renormalizationWindowDays;
        private TimeValue backgroundPersistInterval;
        private Long modelSnapshotRetentionDays;
        private Long dailyModelSnapshotRetentionAfterDays;
        private Long resultsRetentionDays;
        private Map<String, Object> customSettings;
        private String modelSnapshotId;
        private String resultsIndexName;
        private Boolean deleting;
        private Boolean allowLazyOpen;

        private Builder() {
        }

        public Builder(String id) {
            this.id = id;
        }

        public Builder(Job job) {
            this.id = job.getId();
            this.jobType = job.getJobType();
            this.groups = new ArrayList<String>(job.getGroups());
            this.description = job.getDescription();
            this.analysisConfig = job.getAnalysisConfig();
            this.analysisLimits = job.getAnalysisLimits();
            this.dataDescription = job.getDataDescription();
            this.createTime = job.getCreateTime();
            this.finishedTime = job.getFinishedTime();
            this.modelPlotConfig = job.getModelPlotConfig();
            this.renormalizationWindowDays = job.getRenormalizationWindowDays();
            this.backgroundPersistInterval = job.getBackgroundPersistInterval();
            this.modelSnapshotRetentionDays = job.getModelSnapshotRetentionDays();
            this.dailyModelSnapshotRetentionAfterDays = job.getDailyModelSnapshotRetentionAfterDays();
            this.resultsRetentionDays = job.getResultsRetentionDays();
            this.customSettings = job.getCustomSettings() == null ? null : new LinkedHashMap<String, Object>(job.getCustomSettings());
            this.modelSnapshotId = job.getModelSnapshotId();
            this.resultsIndexName = job.getResultsIndexNameNoPrefix();
            this.deleting = job.getDeleting();
            this.allowLazyOpen = job.getAllowLazyOpen();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public Builder setJobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        public Builder setGroups(List<String> groups) {
            this.groups = groups == null ? Collections.emptyList() : groups;
            return this;
        }

        public Builder setCustomSettings(Map<String, Object> customSettings) {
            this.customSettings = customSettings;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setAnalysisConfig(AnalysisConfig.Builder configBuilder) {
            this.analysisConfig = Objects.requireNonNull(configBuilder, ANALYSIS_CONFIG.getPreferredName()).build();
            return this;
        }

        public Builder setAnalysisLimits(AnalysisLimits analysisLimits) {
            this.analysisLimits = Objects.requireNonNull(analysisLimits, ANALYSIS_LIMITS.getPreferredName());
            return this;
        }

        Builder setCreateTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        Builder setFinishedTime(Date finishedTime) {
            this.finishedTime = finishedTime;
            return this;
        }

        public Builder setDataDescription(DataDescription.Builder description) {
            this.dataDescription = Objects.requireNonNull(description, DATA_DESCRIPTION.getPreferredName()).build();
            return this;
        }

        public Builder setModelPlotConfig(ModelPlotConfig modelPlotConfig) {
            this.modelPlotConfig = modelPlotConfig;
            return this;
        }

        public Builder setBackgroundPersistInterval(TimeValue backgroundPersistInterval) {
            this.backgroundPersistInterval = backgroundPersistInterval;
            return this;
        }

        public Builder setRenormalizationWindowDays(Long renormalizationWindowDays) {
            this.renormalizationWindowDays = renormalizationWindowDays;
            return this;
        }

        public Builder setModelSnapshotRetentionDays(Long modelSnapshotRetentionDays) {
            this.modelSnapshotRetentionDays = modelSnapshotRetentionDays;
            return this;
        }

        public Builder setDailyModelSnapshotRetentionAfterDays(Long dailyModelSnapshotRetentionAfterDays) {
            this.dailyModelSnapshotRetentionAfterDays = dailyModelSnapshotRetentionAfterDays;
            return this;
        }

        public Builder setResultsRetentionDays(Long resultsRetentionDays) {
            this.resultsRetentionDays = resultsRetentionDays;
            return this;
        }

        public Builder setModelSnapshotId(String modelSnapshotId) {
            this.modelSnapshotId = modelSnapshotId;
            return this;
        }

        public Builder setResultsIndexName(String resultsIndexName) {
            this.resultsIndexName = resultsIndexName;
            return this;
        }

        Builder setDeleting(Boolean deleting) {
            this.deleting = deleting;
            return this;
        }

        Builder setAllowLazyOpen(Boolean allowLazyOpen) {
            this.allowLazyOpen = allowLazyOpen;
            return this;
        }

        public Job build() {
            Objects.requireNonNull(this.id, "[" + ID.getPreferredName() + "] must not be null");
            Objects.requireNonNull(this.jobType, "[" + JOB_TYPE.getPreferredName() + "] must not be null");
            return new Job(this.id, this.jobType, this.groups, this.description, this.createTime, this.finishedTime, this.analysisConfig, this.analysisLimits, this.dataDescription, this.modelPlotConfig, this.renormalizationWindowDays, this.backgroundPersistInterval, this.modelSnapshotRetentionDays, this.dailyModelSnapshotRetentionAfterDays, this.resultsRetentionDays, this.customSettings, this.modelSnapshotId, this.resultsIndexName, this.deleting, this.allowLazyOpen);
        }
    }
}

