/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.ReindexPlugin;
import org.elasticsearch.percolator.PercolatorPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.mustache.MustachePlugin;
import org.elasticsearch.transport.Netty3Plugin;
import org.elasticsearch.transport.Netty4Plugin;

public class PreBuiltTransportClient
extends TransportClient {
    private static final Collection<Class<? extends Plugin>> PRE_INSTALLED_PLUGINS = Collections.unmodifiableList(Arrays.asList(Netty3Plugin.class, Netty4Plugin.class, TransportPlugin.class, ReindexPlugin.class, PercolatorPlugin.class, MustachePlugin.class));

    @SafeVarargs
    public PreBuiltTransportClient(Settings settings, Class<? extends Plugin> ... plugins) {
        this(settings, Arrays.asList(plugins));
    }

    public PreBuiltTransportClient(Settings settings, Collection<Class<? extends Plugin>> plugins) {
        super(settings, Settings.EMPTY, PreBuiltTransportClient.addPlugins(plugins, PRE_INSTALLED_PLUGINS));
    }

    public static final class TransportPlugin
    extends Plugin {
        private static final Setting<Boolean> ASSERT_NETTY_BUGLEVEL = Setting.boolSetting((String)"netty.assert.buglevel", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

        public List<Setting<?>> getSettings() {
            return Collections.singletonList(ASSERT_NETTY_BUGLEVEL);
        }

        public Settings additionalSettings() {
            return Settings.builder().put("transport.type", "netty4").put("http.type", "netty4").put("netty.assert.buglevel", true).build();
        }
    }
}

