/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.WeekFields;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

enum DateFormat {
    Iso8601{

        @Override
        Function<String, DateTime> getFunction(String format, DateTimeZone timezone, Locale locale) {
            return arg_0 -> ((DateTimeFormatter)ISODateTimeFormat.dateTimeParser().withZone(timezone)).parseDateTime(arg_0);
        }
    }
    ,
    Unix{

        @Override
        Function<String, DateTime> getFunction(String format, DateTimeZone timezone, Locale locale) {
            return date -> new DateTime((long)(Double.parseDouble(date) * 1000.0), timezone);
        }
    }
    ,
    UnixMs{

        @Override
        Function<String, DateTime> getFunction(String format, DateTimeZone timezone, Locale locale) {
            return date -> new DateTime(Long.parseLong(date), timezone);
        }
    }
    ,
    Tai64n{

        @Override
        Function<String, DateTime> getFunction(String format, DateTimeZone timezone, Locale locale) {
            return date -> new DateTime(this.parseMillis((String)date), timezone);
        }

        private long parseMillis(String date) {
            if (date.startsWith("@")) {
                date = date.substring(1);
            }
            long base = Long.parseLong(date.substring(1, 16), 16);
            long rest = Long.parseLong(date.substring(16, 24), 16);
            return base * 1000L - 10000L + rest / 1000000L;
        }
    }
    ,
    Java{
        private final List<ChronoField> FIELDS = Arrays.asList(ChronoField.NANO_OF_SECOND, ChronoField.SECOND_OF_DAY, ChronoField.MINUTE_OF_DAY, ChronoField.HOUR_OF_DAY, ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR);

        @Override
        Function<String, DateTime> getFunction(String format, DateTimeZone timezone, Locale locale) {
            int year = LocalDate.now(ZoneOffset.UTC).getYear();
            if (format.startsWith("8")) {
                DateFormatter formatter = DateFormatter.forPattern((String)format).withLocale(locale).withZone(DateUtils.dateTimeZoneToZoneId((DateTimeZone)timezone));
                return text -> {
                    TemporalAccessor accessor = formatter.parse(text);
                    if (!(accessor.isSupported(ChronoField.YEAR) || accessor.isSupported(ChronoField.YEAR_OF_ERA) || accessor.isSupported(WeekFields.of(locale).weekOfWeekBasedYear()))) {
                        ZonedDateTime newTime = Instant.EPOCH.atZone(ZoneOffset.UTC).withYear(year);
                        for (ChronoField field : this.FIELDS) {
                            if (!accessor.isSupported(field)) continue;
                            newTime = newTime.with(field, accessor.get(field));
                        }
                        accessor = newTime.withZoneSameLocal(DateUtils.dateTimeZoneToZoneId((DateTimeZone)timezone));
                    }
                    long millis = DateFormatters.from((TemporalAccessor)accessor, (Locale)locale).toInstant().toEpochMilli();
                    return new DateTime(millis, timezone);
                };
            }
            DateFormatter formatter = Joda.forPattern((String)format).withYear(year).withZone(DateUtils.dateTimeZoneToZoneId((DateTimeZone)timezone)).withLocale(locale);
            return text -> new DateTime(formatter.parseMillis(text), timezone);
        }
    };


    abstract Function<String, DateTime> getFunction(String var1, DateTimeZone var2, Locale var3);

    static DateFormat fromString(String format) {
        switch (format) {
            case "ISO8601": {
                return Iso8601;
            }
            case "UNIX": {
                return Unix;
            }
            case "UNIX_MS": {
                return UnixMs;
            }
            case "TAI64N": {
                return Tai64n;
            }
        }
        return Java;
    }
}

