/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Normalizer2;
import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.elasticsearch.common.lucene.analysis.CharSequenceTermAttribute;

public class ICUNormalizer2Filter
extends TokenFilter {
    private final TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    private final Normalizer2 normalizer;
    private final StringBuilder buffer = new StringBuilder();
    private final CharSequenceTermAttribute charSequenceTermAtt;

    public ICUNormalizer2Filter(TokenStream input) {
        this(input, Normalizer2.getInstance(null, (String)"nfkc_cf", (Normalizer2.Mode)Normalizer2.Mode.COMPOSE));
    }

    public ICUNormalizer2Filter(TokenStream input, Normalizer2 normalizer) {
        super(input);
        this.normalizer = normalizer;
        this.charSequenceTermAtt = new CharSequenceTermAttribute(this.termAtt);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.normalizer.quickCheck((CharSequence)this.charSequenceTermAtt) != Normalizer.YES) {
                this.buffer.setLength(0);
                this.normalizer.normalize((CharSequence)this.charSequenceTermAtt, this.buffer);
                this.termAtt.setTermBuffer(this.buffer.toString());
            }
            return true;
        }
        return false;
    }
}

