/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.collation.ICUCollationKeyFilter;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.FailedToResolveConfigException;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class IcuCollationTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Collator collator;

    @Inject
    public IcuCollationTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment environment, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        Collator collator;
        String rules = settings.get("rules");
        if (rules != null) {
            FailedToResolveConfigException failureToResolve = null;
            try {
                rules = environment.resolveConfigAndLoadToString(rules);
            }
            catch (FailedToResolveConfigException e) {
                failureToResolve = e;
            }
            catch (IOException e) {
                throw new ElasticSearchIllegalArgumentException("Failed to load collation rules", (Throwable)e);
            }
            try {
                collator = new RuleBasedCollator(rules);
            }
            catch (Exception e) {
                if (failureToResolve != null) {
                    throw new ElasticSearchIllegalArgumentException("Failed to resolve collation rules location", (Throwable)failureToResolve);
                }
                throw new ElasticSearchIllegalArgumentException("Failed to parse collation rules", (Throwable)e);
            }
        }
        String language = settings.get("language");
        if (language != null) {
            String variant;
            String country = settings.get("country");
            Locale locale = country != null ? ((variant = settings.get("variant")) != null ? new Locale(language, country, variant) : new Locale(language, country)) : new Locale(language);
            collator = Collator.getInstance((Locale)locale);
        } else {
            collator = Collator.getInstance();
        }
        this.collator = collator;
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ICUCollationKeyFilter(tokenStream, this.collator);
    }
}

