/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.settings.IndexSettings;

public class KuromojiTokenizerFactory
extends AbstractTokenizerFactory {
    private static final String USER_DICT_OPTION = "user_dictionary";
    private final UserDictionary userDictionary;
    private final JapaneseTokenizer.Mode mode;
    private boolean discartPunctuation;

    @Inject
    public KuromojiTokenizerFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.mode = KuromojiTokenizerFactory.getMode(settings);
        this.userDictionary = KuromojiTokenizerFactory.getUserDictionary(env, settings);
        this.discartPunctuation = settings.getAsBoolean("discard_punctuation", Boolean.valueOf(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserDictionary getUserDictionary(Environment env, Settings settings) {
        UserDictionary userDictionary;
        Reader reader = Analysis.getReaderFromFile((Environment)env, (Settings)settings, (String)USER_DICT_OPTION);
        if (reader == null) {
            return null;
        }
        try {
            userDictionary = new UserDictionary(reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to load kuromoji user dictionary", (Throwable)e);
            }
        }
        reader.close();
        return userDictionary;
    }

    public static JapaneseTokenizer.Mode getMode(Settings settings) {
        JapaneseTokenizer.Mode mode = JapaneseTokenizer.DEFAULT_MODE;
        String modeSetting = settings.get("mode", null);
        if (modeSetting != null) {
            if ("search".equalsIgnoreCase(modeSetting)) {
                mode = JapaneseTokenizer.Mode.SEARCH;
            } else if ("normal".equalsIgnoreCase(modeSetting)) {
                mode = JapaneseTokenizer.Mode.NORMAL;
            } else if ("extended".equalsIgnoreCase(modeSetting)) {
                mode = JapaneseTokenizer.Mode.EXTENDED;
            }
        }
        return mode;
    }

    public Tokenizer create(Reader reader) {
        return new JapaneseTokenizer(reader, this.userDictionary, this.discartPunctuation, this.mode);
    }
}

