/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis.pl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.pl.PolishAnalyzer;
import org.apache.lucene.analysis.stempel.StempelFilter;
import org.apache.lucene.analysis.stempel.StempelStemmer;
import org.egothor.stemmer.Trie;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenFilterFactoryFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;

public class PolishIndicesAnalysis
extends AbstractComponent {
    @Inject
    public PolishIndicesAnalysis(Settings settings, IndicesAnalysisService indicesAnalysisService) {
        super(settings);
        indicesAnalysisService.analyzerProviderFactories().put("polish", new PreBuiltAnalyzerProviderFactory("polish", AnalyzerScope.INDICES, (Analyzer)new PolishAnalyzer(Lucene.ANALYZER_VERSION)));
        indicesAnalysisService.tokenFilterFactories().put("polish_stem", new PreBuiltTokenFilterFactoryFactory(new TokenFilterFactory(){

            public String name() {
                return "polish_stem";
            }

            public TokenStream create(TokenStream tokenStream) {
                Trie tire;
                try {
                    tire = StempelStemmer.load((InputStream)PolishAnalyzer.class.getResourceAsStream("stemmer_20000.tbl"));
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unable to load default stemming tables", ex);
                }
                return new StempelFilter(tokenStream, new StempelStemmer(tire));
            }
        }));
    }
}

