/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.SignerFactory;
import org.elasticsearch.ElasticsearchIllegalArgumentException;

public class AwsSigner {
    private AwsSigner() {
    }

    public static void configureSigner(String signer, ClientConfiguration configuration) throws ElasticsearchIllegalArgumentException {
        if (signer == null) {
            throw new ElasticsearchIllegalArgumentException("[null] signer set");
        }
        try {
            SignerFactory.getSignerByTypeAndService((String)signer, null);
            configuration.setSignerOverride(signer);
        }
        catch (IllegalArgumentException e) {
            throw new ElasticsearchIllegalArgumentException("wrong signer set [" + signer + "]");
        }
    }
}

