/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.aws.network;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;

public class Ec2NameResolver
extends AbstractComponent
implements NetworkService.CustomNameResolver {
    public Ec2NameResolver(Settings settings) {
        super(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress resolve(Ec2HostnameType type, boolean warnOnFailure) {
        InetAddress inetAddress;
        String metadataResult;
        InputStream in;
        block7: {
            URLConnection urlConnection = null;
            in = null;
            URL url = new URL("http://169.254.169.254/latest/meta-data/" + type.ec2Name);
            this.logger.debug("obtaining ec2 hostname from ec2 meta-data url {}", new Object[]{url});
            urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(2000);
            in = urlConnection.getInputStream();
            BufferedReader urlReader = new BufferedReader(new InputStreamReader(in));
            metadataResult = urlReader.readLine();
            if (metadataResult != null && metadataResult.length() != 0) break block7;
            this.logger.error("no ec2 metadata returned from {}", new Object[]{url});
            InetAddress inetAddress2 = null;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
            return inetAddress2;
        }
        try {
            inetAddress = InetAddress.getByName(metadataResult);
        }
        catch (IOException e) {
            InetAddress inetAddress3;
            try {
                if (warnOnFailure) {
                    this.logger.warn("failed to get metadata for [" + type.configName + "]: " + ExceptionsHelper.detailedMessage((Throwable)e), new Object[0]);
                } else {
                    this.logger.debug("failed to get metadata for [" + type.configName + "]: " + ExceptionsHelper.detailedMessage((Throwable)e), new Object[0]);
                }
                inetAddress3 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
            return inetAddress3;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        return inetAddress;
    }

    public InetAddress resolveDefault() {
        return null;
    }

    public InetAddress resolveIfPossible(String value) {
        for (Ec2HostnameType type : Ec2HostnameType.values()) {
            if (!type.configName.equals(value)) continue;
            return this.resolve(type, true);
        }
        return null;
    }

    private static enum Ec2HostnameType {
        PRIVATE_IPv4("ec2:privateIpv4", "local-ipv4"),
        PRIVATE_DNS("ec2:privateDns", "local-hostname"),
        PUBLIC_IPv4("ec2:publicIpv4", "public-ipv4"),
        PUBLIC_DNS("ec2:publicDns", "public-hostname"),
        PUBLIC_IP("ec2:publicIp", Ec2HostnameType.PUBLIC_IPv4.ec2Name),
        PRIVATE_IP("ec2:privateIp", Ec2HostnameType.PRIVATE_IPv4.ec2Name),
        EC2("ec2", Ec2HostnameType.PRIVATE_IPv4.ec2Name);

        final String configName;
        final String ec2Name;

        private Ec2HostnameType(String configName, String ec2Name) {
            this.configName = configName;
            this.ec2Name = ec2Name;
        }
    }
}

