/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.bootstrap;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.entitlement.initialization.EntitlementInitialization;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class EntitlementBootstrap {
    private static final Logger logger = LogManager.getLogger(EntitlementBootstrap.class);

    public static void bootstrap() {
        logger.debug("Loading entitlement agent");
        EntitlementBootstrap.exportInitializationToAgent();
        EntitlementBootstrap.loadAgent(EntitlementBootstrap.findAgentJar());
    }

    @SuppressForbidden(reason="The VirtualMachine API is the only way to attach a java agent dynamically")
    private static void loadAgent(String agentPath) {
        try {
            VirtualMachine vm = VirtualMachine.attach(Long.toString(ProcessHandle.current().pid()));
            try {
                vm.loadAgent(agentPath);
            }
            finally {
                vm.detach();
            }
        }
        catch (AgentInitializationException | AgentLoadException | AttachNotSupportedException | IOException e) {
            throw new IllegalStateException("Unable to attach entitlement agent", e);
        }
    }

    private static void exportInitializationToAgent() {
        String initPkg = EntitlementInitialization.class.getPackageName();
        Module unnamedModule = ClassLoader.getSystemClassLoader().getUnnamedModule();
        EntitlementInitialization.class.getModule().addExports(initPkg, unnamedModule);
    }

    private static String findAgentJar() {
        String string;
        block11: {
            String propertyName = "es.entitlement.agentJar";
            String propertyValue = System.getProperty(propertyName);
            if (propertyValue != null) {
                return propertyValue;
            }
            Path dir = Path.of("lib", "entitlement-agent");
            if (!Files.exists(dir, new LinkOption[0])) {
                throw new IllegalStateException("Directory for entitlement jar does not exist: " + dir);
            }
            Stream<Path> s = Files.list(dir);
            try {
                List<Path> candidates = s.limit(2L).toList();
                if (candidates.size() != 1) {
                    throw new IllegalStateException("Expected one jar in " + dir + "; found " + candidates.size());
                }
                string = candidates.get(0).toString();
                if (s == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to list entitlement jars in: " + dir, e);
                }
            }
            s.close();
        }
        return string;
    }
}

