/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.api;

import java.util.Optional;
import org.elasticsearch.entitlement.bridge.EntitlementChecker;
import org.elasticsearch.entitlement.runtime.api.NotEntitledException;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class ElasticsearchEntitlementChecker
implements EntitlementChecker {
    private static final Logger logger = LogManager.getLogger(ElasticsearchEntitlementChecker.class);

    public void checkSystemExit(Class<?> callerClass, int status) {
        Module requestingModule = ElasticsearchEntitlementChecker.requestingModule(callerClass);
        if (ElasticsearchEntitlementChecker.isTriviallyAllowed(requestingModule)) {
            return;
        }
        throw new NotEntitledException("Missing entitlement for " + requestingModule);
    }

    private static Module requestingModule(Class<?> callerClass) {
        Module callerModule;
        if (callerClass != null && (callerModule = callerClass.getModule()).getLayer() != ModuleLayer.boot()) {
            return callerModule;
        }
        int framesToSkip = 4;
        Optional module = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(s -> s.skip(framesToSkip).map(f -> f.getDeclaringClass().getModule()).filter(m -> m.getLayer() != ModuleLayer.boot()).findFirst());
        return module.orElse(null);
    }

    private static boolean isTriviallyAllowed(Module requestingModule) {
        if (requestingModule == null) {
            logger.debug("Trivially allowed: Entire call stack is in the boot module layer");
            return true;
        }
        if (requestingModule == System.class.getModule()) {
            logger.debug("Trivially allowed: Caller is in {}", new Object[]{System.class.getModule().getName()});
            return true;
        }
        logger.trace("Not trivially allowed");
        return false;
    }
}

