/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.entitlement.runtime.policy.Entitlement;
import org.elasticsearch.entitlement.runtime.policy.ExternalEntitlement;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyParserException;
import org.elasticsearch.entitlement.runtime.policy.Scope;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.yaml.YamlXContent;

public class PolicyParser {
    protected static final ParseField ENTITLEMENTS_PARSEFIELD = new ParseField("entitlements", new String[0]);
    protected static final String entitlementPackageName = Entitlement.class.getPackage().getName();
    protected final XContentParser policyParser;
    protected final String policyName;

    public PolicyParser(InputStream inputStream, String policyName) throws IOException {
        this.policyParser = YamlXContent.yamlXContent.createParser(XContentParserConfiguration.EMPTY, Objects.requireNonNull(inputStream));
        this.policyName = policyName;
    }

    public Policy parsePolicy() {
        try {
            if (this.policyParser.nextToken() != XContentParser.Token.START_OBJECT) {
                throw this.newPolicyParserException("expected object <scope name>");
            }
            ArrayList<Scope> scopes = new ArrayList<Scope>();
            while (this.policyParser.nextToken() != XContentParser.Token.END_OBJECT) {
                if (this.policyParser.currentToken() != XContentParser.Token.FIELD_NAME) {
                    throw this.newPolicyParserException("expected object <scope name>");
                }
                String scopeName = this.policyParser.currentName();
                Scope scope = this.parseScope(scopeName);
                scopes.add(scope);
            }
            return new Policy(this.policyName, scopes);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    protected Scope parseScope(String scopeName) throws IOException {
        try {
            if (this.policyParser.nextToken() != XContentParser.Token.START_OBJECT) {
                throw this.newPolicyParserException(scopeName, "expected object [" + ENTITLEMENTS_PARSEFIELD.getPreferredName() + "]");
            }
            if (this.policyParser.nextToken() != XContentParser.Token.FIELD_NAME || !this.policyParser.currentName().equals(ENTITLEMENTS_PARSEFIELD.getPreferredName())) {
                throw this.newPolicyParserException(scopeName, "expected object [" + ENTITLEMENTS_PARSEFIELD.getPreferredName() + "]");
            }
            if (this.policyParser.nextToken() != XContentParser.Token.START_ARRAY) {
                throw this.newPolicyParserException(scopeName, "expected array of <entitlement type>");
            }
            ArrayList<Entitlement> entitlements = new ArrayList<Entitlement>();
            while (this.policyParser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (this.policyParser.currentToken() != XContentParser.Token.START_OBJECT) {
                    throw this.newPolicyParserException(scopeName, "expected object <entitlement type>");
                }
                if (this.policyParser.nextToken() != XContentParser.Token.FIELD_NAME) {
                    throw this.newPolicyParserException(scopeName, "expected object <entitlement type>");
                }
                String entitlementType = this.policyParser.currentName();
                Entitlement entitlement = this.parseEntitlement(scopeName, entitlementType);
                entitlements.add(entitlement);
                if (this.policyParser.nextToken() == XContentParser.Token.END_OBJECT) continue;
                throw this.newPolicyParserException(scopeName, "expected closing object");
            }
            if (this.policyParser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw this.newPolicyParserException(scopeName, "expected closing object");
            }
            return new Scope(scopeName, entitlements);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    protected Entitlement parseEntitlement(String scopeName, String entitlementType) throws IOException {
        Class<?> entitlementClass;
        try {
            entitlementClass = Class.forName(entitlementPackageName + "." + Character.toUpperCase(entitlementType.charAt(0)) + entitlementType.substring(1) + "Entitlement");
        }
        catch (ClassNotFoundException cnfe) {
            throw this.newPolicyParserException(scopeName, "unknown entitlement type [" + entitlementType + "]");
        }
        if (!Entitlement.class.isAssignableFrom(entitlementClass)) {
            throw this.newPolicyParserException(scopeName, "unknown entitlement type [" + entitlementType + "]");
        }
        Constructor<?> entitlementConstructor = entitlementClass.getConstructors()[0];
        ExternalEntitlement entitlementMetadata = entitlementConstructor.getAnnotation(ExternalEntitlement.class);
        if (entitlementMetadata == null) {
            throw this.newPolicyParserException(scopeName, "unknown entitlement type [" + entitlementType + "]");
        }
        if (this.policyParser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw this.newPolicyParserException(scopeName, entitlementType, "expected entitlement parameters");
        }
        Map parsedValues = this.policyParser.map();
        Class<?>[] parameterTypes = entitlementConstructor.getParameterTypes();
        String[] parametersNames = entitlementMetadata.parameterNames();
        Object[] parameterValues = new Object[parameterTypes.length];
        for (int parameterIndex = 0; parameterIndex < parameterTypes.length; ++parameterIndex) {
            String parameterName = parametersNames[parameterIndex];
            Object parameterValue = parsedValues.remove(parameterName);
            if (parameterValue == null) {
                throw this.newPolicyParserException(scopeName, entitlementType, "missing entitlement parameter [" + parameterName + "]");
            }
            Class<?> parameterType = parameterTypes[parameterIndex];
            if (!parameterType.isAssignableFrom(parameterValue.getClass())) {
                throw this.newPolicyParserException(scopeName, entitlementType, "unexpected parameter type [" + parameterType.getSimpleName() + "] for entitlement parameter [" + parameterName + "]");
            }
            parameterValues[parameterIndex] = parameterValue;
        }
        if (!parsedValues.isEmpty()) {
            throw this.newPolicyParserException(scopeName, entitlementType, "extraneous entitlement parameter(s) " + parsedValues);
        }
        try {
            return (Entitlement)entitlementConstructor.newInstance(parameterValues);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("internal error");
        }
    }

    protected PolicyParserException newPolicyParserException(String message) {
        return PolicyParserException.newPolicyParserException(this.policyParser.getTokenLocation(), this.policyName, message);
    }

    protected PolicyParserException newPolicyParserException(String scopeName, String message) {
        return PolicyParserException.newPolicyParserException(this.policyParser.getTokenLocation(), this.policyName, scopeName, message);
    }

    protected PolicyParserException newPolicyParserException(String scopeName, String entitlementType, String message) {
        return PolicyParserException.newPolicyParserException(this.policyParser.getTokenLocation(), this.policyName, scopeName, entitlementType, message);
    }
}

