/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.entitlement.runtime.policy.Entitlement;
import org.elasticsearch.entitlement.runtime.policy.ExternalEntitlement;

public class FileEntitlement
implements Entitlement {
    public static final int READ_ACTION = 1;
    public static final int WRITE_ACTION = 2;
    private final String path;
    private final int actions;

    @ExternalEntitlement(parameterNames={"path", "actions"})
    public FileEntitlement(String path, List<String> actionsList) {
        this.path = path;
        int actionsInt = 0;
        for (String actionString : actionsList) {
            if ("read".equals(actionString)) {
                if ((actionsInt & 1) == 1) {
                    throw new IllegalArgumentException("file action [read] specified multiple times");
                }
                actionsInt |= 1;
                continue;
            }
            if ("write".equals(actionString)) {
                if ((actionsInt & 2) == 2) {
                    throw new IllegalArgumentException("file action [write] specified multiple times");
                }
                actionsInt |= 2;
                continue;
            }
            throw new IllegalArgumentException("unknown file action [" + actionString + "]");
        }
        this.actions = actionsInt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileEntitlement that = (FileEntitlement)o;
        return this.actions == that.actions && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.actions);
    }

    public String toString() {
        return "FileEntitlement{path='" + this.path + "', actions=" + this.actions + "}";
    }
}

