/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.initialization;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.channels.spi.SelectorProvider;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.internal.provider.ProviderLocator;
import org.elasticsearch.entitlement.bootstrap.EntitlementBootstrap;
import org.elasticsearch.entitlement.bridge.EntitlementChecker;
import org.elasticsearch.entitlement.instrumentation.CheckMethod;
import org.elasticsearch.entitlement.instrumentation.InstrumentationService;
import org.elasticsearch.entitlement.instrumentation.Instrumenter;
import org.elasticsearch.entitlement.instrumentation.MethodKey;
import org.elasticsearch.entitlement.instrumentation.Transformer;
import org.elasticsearch.entitlement.runtime.api.ElasticsearchEntitlementChecker;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.Platform;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyManager;
import org.elasticsearch.entitlement.runtime.policy.PolicyUtils;
import org.elasticsearch.entitlement.runtime.policy.Scope;
import org.elasticsearch.entitlement.runtime.policy.entitlements.CreateClassLoaderEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.Entitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ExitVMEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.FilesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.InboundNetworkEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.LoadNativeLibrariesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ManageThreadsEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.OutboundNetworkEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ReadStoreAttributesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.SetHttpsConnectionPropertiesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.WriteSystemPropertiesEntitlement;

public class EntitlementInitialization {
    private static final String AGENTS_PACKAGE_NAME = "co.elastic.apm.agent";
    private static final Module ENTITLEMENTS_MODULE = PolicyManager.class.getModule();
    private static ElasticsearchEntitlementChecker manager;
    private static final InstrumentationService INSTRUMENTATION_SERVICE;

    public static EntitlementChecker checker() {
        return manager;
    }

    public static void initialize(Instrumentation inst) throws Exception {
        manager = EntitlementInitialization.initChecker();
        Class<?> latestCheckerInterface = EntitlementInitialization.getVersionSpecificCheckerClass(EntitlementChecker.class, Runtime.version().feature());
        boolean verifyBytecode = Booleans.parseBoolean((String)System.getProperty("es.entitlements.verify_bytecode", "false"));
        if (verifyBytecode) {
            EntitlementInitialization.ensureClassesSensitiveToVerificationAreInitialized();
        }
        HashMap<MethodKey, CheckMethod> checkMethods = new HashMap<MethodKey, CheckMethod>(INSTRUMENTATION_SERVICE.lookupMethods(latestCheckerInterface));
        Stream.of(EntitlementInitialization.fileSystemProviderChecks(), EntitlementInitialization.fileStoreChecks(), EntitlementInitialization.pathChecks(), Stream.of(INSTRUMENTATION_SERVICE.lookupImplementationMethod(SelectorProvider.class, "inheritedChannel", SelectorProvider.provider().getClass(), EntitlementChecker.class, "checkSelectorProviderInheritedChannel", new Class[0]))).flatMap(Function.identity()).forEach(instrumentation -> checkMethods.put(instrumentation.targetMethod(), instrumentation.checkMethod()));
        Set<String> classesToTransform = checkMethods.keySet().stream().map(MethodKey::className).collect(Collectors.toSet());
        Instrumenter instrumenter = INSTRUMENTATION_SERVICE.newInstrumenter(latestCheckerInterface, checkMethods);
        Transformer transformer = new Transformer(instrumenter, classesToTransform, verifyBytecode);
        inst.addTransformer(transformer, true);
        Class<?>[] classesToRetransform = EntitlementInitialization.findClassesToRetransform(inst.getAllLoadedClasses(), classesToTransform);
        try {
            inst.retransformClasses(classesToRetransform);
        }
        catch (VerifyError e) {
            transformer.enableClassVerification();
            for (Class<?> classToRetransform : classesToRetransform) {
                inst.retransformClasses(classToRetransform);
            }
            throw e;
        }
    }

    private static Class<?>[] findClassesToRetransform(Class<?>[] loadedClasses, Set<String> classesToTransform) {
        ArrayList retransform = new ArrayList();
        for (Class<?> loadedClass : loadedClasses) {
            if (!classesToTransform.contains(loadedClass.getName().replace(".", "/"))) continue;
            retransform.add(loadedClass);
        }
        return retransform.toArray(new Class[0]);
    }

    private static PolicyManager createPolicyManager() {
        EntitlementBootstrap.BootstrapArgs bootstrapArgs = EntitlementBootstrap.bootstrapArgs();
        Map<String, Policy> pluginPolicies = bootstrapArgs.pluginPolicies();
        PathLookup pathLookup = new PathLookup(EntitlementInitialization.getUserHome(), bootstrapArgs.configDir(), bootstrapArgs.dataDirs(), bootstrapArgs.sharedRepoDirs(), bootstrapArgs.tempDir(), bootstrapArgs.settingResolver());
        ArrayList<Scope> serverScopes = new ArrayList<Scope>();
        ArrayList<FilesEntitlement.FileData> serverModuleFileDatas = new ArrayList<FilesEntitlement.FileData>();
        Collections.addAll(serverModuleFileDatas, FilesEntitlement.FileData.ofPath(bootstrapArgs.pluginsDir(), FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofPath(bootstrapArgs.modulesDir(), FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofPath(bootstrapArgs.configDir(), FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofPath(bootstrapArgs.logsDir(), FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofPath(bootstrapArgs.libDir(), FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofRelativePath(Path.of("", new String[0]), FilesEntitlement.BaseDir.DATA, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofRelativePath(Path.of("", new String[0]), FilesEntitlement.BaseDir.SHARED_REPO, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofRelativePath(Path.of("operator/settings.json", new String[0]), FilesEntitlement.BaseDir.CONFIG, FilesEntitlement.Mode.READ_WRITE).withExclusive(true), FilesEntitlement.FileData.ofPath(Path.of("/etc/os-release", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/etc/system-release", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/usr/lib/os-release", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/proc/sys/vm/max_map_count", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/proc/meminfo", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/proc/loadavg", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/proc/self/cgroup", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/sys/fs/cgroup/", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/proc/self/mountinfo", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX), FilesEntitlement.FileData.ofPath(Path.of("/proc/diskstats", new String[0]), FilesEntitlement.Mode.READ).withPlatform(Platform.LINUX));
        if (bootstrapArgs.pidFile() != null) {
            serverModuleFileDatas.add(FilesEntitlement.FileData.ofPath(bootstrapArgs.pidFile(), FilesEntitlement.Mode.READ_WRITE));
        }
        Collections.addAll(serverScopes, new Scope("org.elasticsearch.base", List.of(new CreateClassLoaderEntitlement(), new FilesEntitlement(List.of(FilesEntitlement.FileData.ofRelativePath(Path.of("", new String[0]), FilesEntitlement.BaseDir.SHARED_REPO, FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofRelativePath(Path.of("", new String[0]), FilesEntitlement.BaseDir.DATA, FilesEntitlement.Mode.READ_WRITE))))), new Scope("org.elasticsearch.xcontent", List.of(new CreateClassLoaderEntitlement())), new Scope("org.elasticsearch.server", List.of(new ExitVMEntitlement(), new ReadStoreAttributesEntitlement(), new CreateClassLoaderEntitlement(), new InboundNetworkEntitlement(), new OutboundNetworkEntitlement(), new LoadNativeLibrariesEntitlement(), new ManageThreadsEntitlement(), new FilesEntitlement(serverModuleFileDatas))), new Scope("java.desktop", List.of(new LoadNativeLibrariesEntitlement())), new Scope("org.apache.httpcomponents.httpclient", List.of(new OutboundNetworkEntitlement())), new Scope("io.netty.transport", List.of(new InboundNetworkEntitlement(), new OutboundNetworkEntitlement())), new Scope("org.apache.lucene.core", List.of(new LoadNativeLibrariesEntitlement(), new ManageThreadsEntitlement(), new FilesEntitlement(List.of(FilesEntitlement.FileData.ofPath(bootstrapArgs.configDir(), FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofRelativePath(Path.of("", new String[0]), FilesEntitlement.BaseDir.DATA, FilesEntitlement.Mode.READ_WRITE))))), new Scope("org.apache.lucene.misc", List.of(new FilesEntitlement(List.of(FilesEntitlement.FileData.ofRelativePath(Path.of("", new String[0]), FilesEntitlement.BaseDir.DATA, FilesEntitlement.Mode.READ_WRITE))))), new Scope("org.apache.logging.log4j.core", List.of(new ManageThreadsEntitlement(), new FilesEntitlement(List.of(FilesEntitlement.FileData.ofPath(bootstrapArgs.logsDir(), FilesEntitlement.Mode.READ_WRITE))))), new Scope("org.elasticsearch.nativeaccess", List.of(new LoadNativeLibrariesEntitlement(), new FilesEntitlement(List.of(FilesEntitlement.FileData.ofRelativePath(Path.of("", new String[0]), FilesEntitlement.BaseDir.DATA, FilesEntitlement.Mode.READ_WRITE))))));
        if (Booleans.parseBoolean((String)System.getProperty("org.bouncycastle.fips.approved_only"), (boolean)false)) {
            String trustStore = System.getProperty("javax.net.ssl.trustStore");
            Path trustStorePath = trustStore != null ? Path.of(trustStore, new String[0]) : Path.of(System.getProperty("java.home"), new String[0]).resolve("lib/security/jssecacerts");
            Collections.addAll(serverScopes, new Scope("org.bouncycastle.fips.tls", List.of(new FilesEntitlement(List.of(FilesEntitlement.FileData.ofPath(trustStorePath, FilesEntitlement.Mode.READ))), new ManageThreadsEntitlement(), new OutboundNetworkEntitlement())), new Scope("org.bouncycastle.fips.core", List.of(new FilesEntitlement(List.of(FilesEntitlement.FileData.ofPath(bootstrapArgs.libDir(), FilesEntitlement.Mode.READ))), new ManageThreadsEntitlement())));
        }
        Policy serverPolicy = new Policy("server", bootstrapArgs.serverPolicyPatch() == null ? serverScopes : PolicyUtils.mergeScopes(serverScopes, bootstrapArgs.serverPolicyPatch().scopes()));
        List<Entitlement> agentEntitlements = List.of(new CreateClassLoaderEntitlement(), new ManageThreadsEntitlement(), new SetHttpsConnectionPropertiesEntitlement(), new OutboundNetworkEntitlement(), new WriteSystemPropertiesEntitlement(Set.of("AsyncProfiler.safemode")), new LoadNativeLibrariesEntitlement(), new FilesEntitlement(List.of(FilesEntitlement.FileData.ofPath(bootstrapArgs.logsDir(), FilesEntitlement.Mode.READ_WRITE), FilesEntitlement.FileData.ofPath(Path.of("/proc/meminfo", new String[0]), FilesEntitlement.Mode.READ), FilesEntitlement.FileData.ofPath(Path.of("/sys/fs/cgroup/", new String[0]), FilesEntitlement.Mode.READ))));
        return new PolicyManager(serverPolicy, agentEntitlements, pluginPolicies, EntitlementBootstrap.bootstrapArgs().pluginResolver(), EntitlementBootstrap.bootstrapArgs().sourcePaths(), AGENTS_PACKAGE_NAME, ENTITLEMENTS_MODULE, pathLookup, bootstrapArgs.suppressFailureLogClasses());
    }

    private static Path getUserHome() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new IllegalStateException("user.home system property is required");
        }
        return PathUtils.get((String)userHome, (String[])new String[0]);
    }

    private static Stream<InstrumentationService.InstrumentationInfo> fileSystemProviderChecks() throws ClassNotFoundException, NoSuchMethodException {
        final Class<?> fileSystemProviderClass = FileSystems.getDefault().provider().getClass();
        var instrumentation = new InstrumentationInfoFactory(){

            @Override
            public InstrumentationService.InstrumentationInfo of(String methodName, Class<?> ... parameterTypes) throws ClassNotFoundException, NoSuchMethodException {
                return INSTRUMENTATION_SERVICE.lookupImplementationMethod(FileSystemProvider.class, methodName, fileSystemProviderClass, EntitlementChecker.class, "check" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1), parameterTypes);
            }
        };
        Stream<InstrumentationService.InstrumentationInfo> allVersionsMethods = Stream.of(instrumentation.of("newFileSystem", URI.class, Map.class), instrumentation.of("newFileSystem", Path.class, Map.class), instrumentation.of("newInputStream", Path.class, OpenOption[].class), instrumentation.of("newOutputStream", Path.class, OpenOption[].class), instrumentation.of("newFileChannel", Path.class, Set.class, FileAttribute[].class), instrumentation.of("newAsynchronousFileChannel", Path.class, Set.class, ExecutorService.class, FileAttribute[].class), instrumentation.of("newByteChannel", Path.class, Set.class, FileAttribute[].class), instrumentation.of("newDirectoryStream", Path.class, DirectoryStream.Filter.class), instrumentation.of("createDirectory", Path.class, FileAttribute[].class), instrumentation.of("createSymbolicLink", Path.class, Path.class, FileAttribute[].class), instrumentation.of("createLink", Path.class, Path.class), instrumentation.of("delete", Path.class), instrumentation.of("deleteIfExists", Path.class), instrumentation.of("readSymbolicLink", Path.class), instrumentation.of("copy", Path.class, Path.class, CopyOption[].class), instrumentation.of("move", Path.class, Path.class, CopyOption[].class), instrumentation.of("isSameFile", Path.class, Path.class), instrumentation.of("isHidden", Path.class), instrumentation.of("getFileStore", Path.class), instrumentation.of("checkAccess", Path.class, AccessMode[].class), instrumentation.of("getFileAttributeView", Path.class, Class.class, LinkOption[].class), instrumentation.of("readAttributes", Path.class, Class.class, LinkOption[].class), instrumentation.of("readAttributes", Path.class, String.class, LinkOption[].class), instrumentation.of("setAttribute", Path.class, String.class, Object.class, LinkOption[].class));
        if (Runtime.version().feature() >= 20) {
            Class<?> java20EntitlementCheckerClass = EntitlementInitialization.getVersionSpecificCheckerClass(EntitlementChecker.class, 20);
            Stream<InstrumentationService.InstrumentationInfo> java20Methods = Stream.of(INSTRUMENTATION_SERVICE.lookupImplementationMethod(FileSystemProvider.class, "readAttributesIfExists", fileSystemProviderClass, java20EntitlementCheckerClass, "checkReadAttributesIfExists", Path.class, Class.class, LinkOption[].class), INSTRUMENTATION_SERVICE.lookupImplementationMethod(FileSystemProvider.class, "exists", fileSystemProviderClass, java20EntitlementCheckerClass, "checkExists", Path.class, LinkOption[].class));
            return Stream.concat(allVersionsMethods, java20Methods);
        }
        return allVersionsMethods;
    }

    private static Stream<InstrumentationService.InstrumentationInfo> fileStoreChecks() {
        Stream<Class> fileStoreClasses = StreamSupport.stream(FileSystems.getDefault().getFileStores().spliterator(), false).map(Object::getClass).distinct();
        return fileStoreClasses.flatMap(fileStoreClass -> {
            var instrumentation = new InstrumentationInfoFactory((Class)fileStoreClass){
                final /* synthetic */ Class val$fileStoreClass;
                {
                    this.val$fileStoreClass = clazz;
                }

                @Override
                public InstrumentationService.InstrumentationInfo of(String methodName, Class<?> ... parameterTypes) throws ClassNotFoundException, NoSuchMethodException {
                    return INSTRUMENTATION_SERVICE.lookupImplementationMethod(FileStore.class, methodName, this.val$fileStoreClass, EntitlementChecker.class, "check" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1), parameterTypes);
                }
            };
            try {
                return Stream.of(instrumentation.of("getFileStoreAttributeView", Class.class), instrumentation.of("getAttribute", String.class), instrumentation.of("getBlockSize", new Class[0]), instrumentation.of("getTotalSpace", new Class[0]), instrumentation.of("getUnallocatedSpace", new Class[0]), instrumentation.of("getUsableSpace", new Class[0]), instrumentation.of("isReadOnly", new Class[0]), instrumentation.of("name", new Class[0]), instrumentation.of("type", new Class[0]));
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Stream<InstrumentationService.InstrumentationInfo> pathChecks() {
        Stream<Class> pathClasses = StreamSupport.stream(FileSystems.getDefault().getRootDirectories().spliterator(), false).map(Object::getClass).distinct();
        return pathClasses.flatMap(pathClass -> {
            InstrumentationInfoFactory instrumentation = (methodName, parameterTypes) -> INSTRUMENTATION_SERVICE.lookupImplementationMethod(Path.class, methodName, (Class<?>)pathClass, EntitlementChecker.class, "checkPath" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1), parameterTypes);
            try {
                return Stream.of(instrumentation.of("toRealPath", LinkOption[].class), instrumentation.of("register", WatchService.class, WatchEvent.Kind[].class), instrumentation.of("register", WatchService.class, WatchEvent.Kind[].class, WatchEvent.Modifier[].class));
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void ensureClassesSensitiveToVerificationAreInitialized() {
        Set<String> classesToInitialize = Set.of("sun.net.www.protocol.http.HttpURLConnection", "sun.nio.ch.SocketChannelImpl", "java.net.ProxySelector");
        for (String className : classesToInitialize) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException unexpected) {
                throw new AssertionError((Object)unexpected);
            }
        }
    }

    private static Class<?> getVersionSpecificCheckerClass(Class<?> baseClass, int javaVersion) {
        Class<?> clazz;
        String packageName = baseClass.getPackageName();
        String baseClassName = baseClass.getSimpleName();
        Object classNamePrefix = javaVersion < 19 ? "" : (javaVersion < 23 ? "Java" + javaVersion : "Java23");
        String className = packageName + "." + (String)classNamePrefix + baseClassName;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError("entitlement lib cannot find entitlement class " + className, e);
        }
        return clazz;
    }

    private static ElasticsearchEntitlementChecker initChecker() {
        Constructor<?> constructor;
        PolicyManager policyManager = EntitlementInitialization.createPolicyManager();
        Class<?> clazz = EntitlementInitialization.getVersionSpecificCheckerClass(ElasticsearchEntitlementChecker.class, Runtime.version().feature());
        try {
            constructor = clazz.getConstructor(PolicyManager.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("entitlement impl is missing no arg constructor", e);
        }
        try {
            return (ElasticsearchEntitlementChecker)constructor.newInstance(policyManager);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        INSTRUMENTATION_SERVICE = (InstrumentationService)new ProviderLocator("entitlement", InstrumentationService.class, "org.elasticsearch.entitlement.instrumentation", Set.of()).get();
    }

    static interface InstrumentationInfoFactory {
        public InstrumentationService.InstrumentationInfo of(String var1, Class<?> ... var2) throws ClassNotFoundException, NoSuchMethodException;
    }
}

