/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;

public record PathLookupImpl(Path homeDir, Path configDir, Path[] dataDirs, Path[] sharedRepoDirs, Path libDir, Path modulesDir, Path pluginsDir, Path logsDir, Path tempDir, Path pidFile, Function<String, Stream<String>> settingResolver) implements PathLookup
{
    public PathLookupImpl {
        Objects.requireNonNull(homeDir);
        Objects.requireNonNull(dataDirs);
        if (dataDirs.length == 0) {
            throw new IllegalArgumentException("must provide at least one data directory");
        }
        Objects.requireNonNull(sharedRepoDirs);
        Objects.requireNonNull(configDir);
        Objects.requireNonNull(libDir);
        Objects.requireNonNull(modulesDir);
        Objects.requireNonNull(pluginsDir);
        Objects.requireNonNull(logsDir);
        Objects.requireNonNull(tempDir);
        Objects.requireNonNull(settingResolver);
    }

    @Override
    public Stream<Path> getBaseDirPaths(PathLookup.BaseDir baseDir) {
        return switch (baseDir) {
            default -> throw new IncompatibleClassChangeError();
            case PathLookup.BaseDir.USER_HOME -> Stream.of(this.homeDir);
            case PathLookup.BaseDir.DATA -> Arrays.stream(this.dataDirs);
            case PathLookup.BaseDir.SHARED_REPO -> Arrays.stream(this.sharedRepoDirs);
            case PathLookup.BaseDir.CONFIG -> Stream.of(this.configDir);
            case PathLookup.BaseDir.LIB -> Stream.of(this.libDir);
            case PathLookup.BaseDir.MODULES -> Stream.of(this.modulesDir);
            case PathLookup.BaseDir.PLUGINS -> Stream.of(this.pluginsDir);
            case PathLookup.BaseDir.LOGS -> Stream.of(this.logsDir);
            case PathLookup.BaseDir.TEMP -> Stream.of(this.tempDir);
        };
    }

    @Override
    public Stream<Path> resolveRelativePaths(PathLookup.BaseDir baseDir, Path relativePath) {
        return this.getBaseDirPaths(baseDir).map(path -> path.resolve(relativePath));
    }

    @Override
    public Stream<Path> resolveSettingPaths(PathLookup.BaseDir baseDir, String settingName) {
        List<Path> relativePaths = this.settingResolver.apply(settingName).filter(s -> !s.toLowerCase(Locale.ROOT).startsWith("https://")).distinct().map(x$0 -> Path.of(x$0, new String[0])).toList();
        return this.getBaseDirPaths(baseDir).flatMap(path -> relativePaths.stream().map(path::resolve));
    }
}

