/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.entitlement.runtime.policy.ExternalEntitlement;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyParserException;
import org.elasticsearch.entitlement.runtime.policy.PolicyValidationException;
import org.elasticsearch.entitlement.runtime.policy.Scope;
import org.elasticsearch.entitlement.runtime.policy.VersionedPolicy;
import org.elasticsearch.entitlement.runtime.policy.entitlements.CreateClassLoaderEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.Entitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.FilesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.InboundNetworkEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.LoadNativeLibrariesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.ManageThreadsEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.OutboundNetworkEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.SetHttpsConnectionPropertiesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.WriteAllSystemPropertiesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.WriteSystemPropertiesEntitlement;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.yaml.YamlXContent;

public class PolicyParser {
    private static final Map<String, Class<? extends Entitlement>> EXTERNAL_ENTITLEMENTS = Stream.of(CreateClassLoaderEntitlement.class, FilesEntitlement.class, InboundNetworkEntitlement.class, LoadNativeLibrariesEntitlement.class, ManageThreadsEntitlement.class, OutboundNetworkEntitlement.class, SetHttpsConnectionPropertiesEntitlement.class, WriteAllSystemPropertiesEntitlement.class, WriteSystemPropertiesEntitlement.class).collect(Collectors.toUnmodifiableMap(PolicyParser::getEntitlementTypeName, Function.identity()));
    protected final XContentParser policyParser;
    protected final String policyName;
    private final boolean isExternalPlugin;
    private final Map<String, Class<? extends Entitlement>> externalEntitlements;

    static String getEntitlementTypeName(Class<? extends Entitlement> entitlementClass) {
        String entitlementClassName = entitlementClass.getSimpleName();
        if (!entitlementClassName.endsWith("Entitlement")) {
            throw new IllegalArgumentException(entitlementClassName + " is not a valid Entitlement class name. A valid class name must end with 'Entitlement'");
        }
        String strippedClassName = entitlementClassName.substring(0, entitlementClassName.indexOf("Entitlement"));
        return Arrays.stream(strippedClassName.split("(?=\\p{Lu})")).filter(Predicate.not(String::isEmpty)).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.joining("_"));
    }

    public PolicyParser(InputStream inputStream, String policyName, boolean isExternalPlugin) throws IOException {
        this(inputStream, policyName, isExternalPlugin, EXTERNAL_ENTITLEMENTS);
    }

    PolicyParser(InputStream inputStream, String policyName, boolean isExternalPlugin, Map<String, Class<? extends Entitlement>> externalEntitlements) throws IOException {
        this.policyParser = YamlXContent.yamlXContent.createParser(XContentParserConfiguration.EMPTY, Objects.requireNonNull(inputStream));
        this.policyName = policyName;
        this.isExternalPlugin = isExternalPlugin;
        this.externalEntitlements = externalEntitlements;
    }

    public VersionedPolicy parseVersionedPolicy() {
        Set<String> versions = Set.of();
        Policy policy = this.emptyPolicy();
        try {
            if (this.policyParser.nextToken() != XContentParser.Token.START_OBJECT) {
                throw this.newPolicyParserException("expected object <versioned policy>");
            }
            while (this.policyParser.nextToken() != XContentParser.Token.END_OBJECT) {
                if (this.policyParser.currentToken() == XContentParser.Token.FIELD_NAME) {
                    if (this.policyParser.currentName().equals("versions")) {
                        versions = this.parseVersions();
                        continue;
                    }
                    if (this.policyParser.currentName().equals("policy")) {
                        policy = this.parsePolicy();
                        continue;
                    }
                    throw this.newPolicyParserException("expected either <version> or <policy> field");
                }
                throw this.newPolicyParserException("expected either <version> or <policy> field");
            }
            return new VersionedPolicy(policy, versions);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private Policy emptyPolicy() {
        return new Policy(this.policyName, List.of());
    }

    private Set<String> parseVersions() throws IOException {
        try {
            if (this.policyParser.nextToken() != XContentParser.Token.START_ARRAY) {
                throw this.newPolicyParserException("expected array of <versions>");
            }
            HashSet<String> versions = new HashSet<String>();
            while (this.policyParser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (this.policyParser.currentToken() == XContentParser.Token.VALUE_STRING) {
                    String version = this.policyParser.text();
                    versions.add(version);
                    continue;
                }
                throw this.newPolicyParserException("expected <version>");
            }
            return versions;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public Policy parsePolicy() {
        try {
            if (this.policyParser.nextToken() != XContentParser.Token.START_OBJECT) {
                throw this.newPolicyParserException("expected object <scope name>");
            }
            ArrayList<Scope> scopes = new ArrayList<Scope>();
            while (this.policyParser.nextToken() != XContentParser.Token.END_OBJECT) {
                if (this.policyParser.currentToken() != XContentParser.Token.FIELD_NAME) {
                    throw this.newPolicyParserException("expected object <scope name>");
                }
                String scopeName = this.policyParser.currentName();
                Scope scope = this.parseScope(scopeName);
                scopes.add(scope);
            }
            return new Policy(this.policyName, scopes);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    protected Scope parseScope(String scopeName) throws IOException {
        try {
            if (this.policyParser.nextToken() != XContentParser.Token.START_ARRAY) {
                throw this.newPolicyParserException(scopeName, "expected array of <entitlement type>");
            }
            ArrayList<Entitlement> entitlements = new ArrayList<Entitlement>();
            while (this.policyParser.nextToken() != XContentParser.Token.END_ARRAY) {
                Entitlement entitlement;
                String entitlementType;
                if (this.policyParser.currentToken() == XContentParser.Token.VALUE_STRING) {
                    entitlementType = this.policyParser.text();
                    entitlement = this.parseEntitlement(scopeName, entitlementType);
                    entitlements.add(entitlement);
                    continue;
                }
                if (this.policyParser.currentToken() == XContentParser.Token.START_OBJECT) {
                    if (this.policyParser.nextToken() != XContentParser.Token.FIELD_NAME) {
                        throw this.newPolicyParserException(scopeName, "expected object <entitlement type>");
                    }
                    entitlementType = this.policyParser.currentName();
                    entitlement = this.parseEntitlement(scopeName, entitlementType);
                    entitlements.add(entitlement);
                    if (this.policyParser.nextToken() == XContentParser.Token.END_OBJECT) continue;
                    throw this.newPolicyParserException(scopeName, "expected closing object");
                }
                throw this.newPolicyParserException(scopeName, "expected object <entitlement type>");
            }
            return new Scope(scopeName, entitlements);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    protected Entitlement parseEntitlement(String scopeName, String entitlementType) throws IOException {
        ExternalEntitlement metadata;
        XContentLocation startLocation = this.policyParser.getTokenLocation();
        Class<? extends Entitlement> entitlementClass = this.externalEntitlements.get(entitlementType);
        if (entitlementClass == null) {
            throw this.newPolicyParserException(scopeName, "unknown entitlement type [" + entitlementType + "]");
        }
        Constructor<?> entitlementConstructor = null;
        Executable entitlementMethod = null;
        ExternalEntitlement entitlementMetadata = null;
        for (Constructor<?> constructor : entitlementClass.getConstructors()) {
            metadata = constructor.getAnnotation(ExternalEntitlement.class);
            if (metadata == null) continue;
            if (entitlementMetadata != null) {
                throw new IllegalStateException("entitlement class [" + entitlementClass.getName() + "] has more than one constructor annotated with ExternalEntitlement");
            }
            entitlementConstructor = constructor;
            entitlementMetadata = metadata;
        }
        for (Executable executable : entitlementClass.getMethods()) {
            metadata = ((Method)executable).getAnnotation(ExternalEntitlement.class);
            if (metadata == null) continue;
            if (!Modifier.isStatic(((Method)executable).getModifiers())) {
                throw new IllegalStateException("entitlement class [" + entitlementClass.getName() + "] has non-static method annotated with ExternalEntitlement");
            }
            if (entitlementMetadata != null) {
                throw new IllegalStateException("entitlement class [" + entitlementClass.getName() + "] has more than one constructor and/or method annotated with ExternalEntitlement");
            }
            entitlementMethod = executable;
            entitlementMetadata = metadata;
        }
        if (entitlementMetadata == null) {
            throw this.newPolicyParserException(scopeName, "unknown entitlement type [" + entitlementType + "]");
        }
        if (entitlementMetadata.esModulesOnly() && this.isExternalPlugin) {
            throw this.newPolicyParserException("entitlement type [" + entitlementType + "] is allowed only on modules");
        }
        Class<?>[] parameterTypes = entitlementConstructor != null ? entitlementConstructor.getParameterTypes() : ((Method)entitlementMethod).getParameterTypes();
        String[] parametersNames = entitlementMetadata.parameterNames();
        Object[] parameterValues = new Object[parameterTypes.length];
        if (parameterTypes.length != 0 || parametersNames.length != 0) {
            if (this.policyParser.nextToken() == XContentParser.Token.START_OBJECT) {
                Map map = this.policyParser.map();
                for (int parameterIndex = 0; parameterIndex < parameterTypes.length; ++parameterIndex) {
                    String parameterName = parametersNames[parameterIndex];
                    Object parameterValue = map.remove(parameterName);
                    if (parameterValue == null) {
                        throw this.newPolicyParserException(scopeName, entitlementType, "missing entitlement parameter [" + parameterName + "]");
                    }
                    Class<?> parameterType = parameterTypes[parameterIndex];
                    if (!parameterType.isAssignableFrom(parameterValue.getClass())) {
                        throw this.newPolicyParserException(scopeName, entitlementType, "unexpected parameter type [" + parameterType.getSimpleName() + "] for entitlement parameter [" + parameterName + "]");
                    }
                    parameterValues[parameterIndex] = parameterValue;
                }
                if (!map.isEmpty()) {
                    throw this.newPolicyParserException(scopeName, entitlementType, "extraneous entitlement parameter(s) " + String.valueOf(map));
                }
            } else if (this.policyParser.currentToken() == XContentParser.Token.START_ARRAY) {
                List list = this.policyParser.list();
                parameterValues[0] = list;
            } else {
                throw this.newPolicyParserException(scopeName, entitlementType, "expected entitlement parameters");
            }
        }
        try {
            if (entitlementConstructor != null) {
                return (Entitlement)entitlementConstructor.newInstance(parameterValues);
            }
            return (Entitlement)((Method)entitlementMethod).invoke(null, parameterValues);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            Throwable throwable = reflectiveOperationException.getCause();
            if (throwable instanceof PolicyValidationException) {
                PolicyValidationException piae = (PolicyValidationException)throwable;
                throw this.newPolicyParserException(startLocation, scopeName, entitlementType, piae);
            }
            throw new IllegalStateException("internal error", reflectiveOperationException);
        }
    }

    protected PolicyParserException newPolicyParserException(String message) {
        return PolicyParserException.newPolicyParserException(this.policyParser.getTokenLocation(), this.policyName, message);
    }

    protected PolicyParserException newPolicyParserException(String scopeName, String message) {
        return PolicyParserException.newPolicyParserException(this.policyParser.getTokenLocation(), this.policyName, scopeName, message);
    }

    protected PolicyParserException newPolicyParserException(String scopeName, String entitlementType, String message) {
        return PolicyParserException.newPolicyParserException(this.policyParser.getTokenLocation(), this.policyName, scopeName, entitlementType, message);
    }

    protected PolicyParserException newPolicyParserException(XContentLocation location, String scopeName, String entitlementType, PolicyValidationException cause) {
        return PolicyParserException.newPolicyParserException(location, this.policyName, scopeName, entitlementType, cause);
    }
}

