/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.core.Strings;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyParser;
import org.elasticsearch.entitlement.runtime.policy.Scope;
import org.elasticsearch.entitlement.runtime.policy.VersionedPolicy;
import org.elasticsearch.entitlement.runtime.policy.entitlements.Entitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.FilesEntitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.WriteSystemPropertiesEntitlement;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class PolicyUtils {
    private static final Logger logger = LogManager.getLogger(PolicyUtils.class);
    private static final String POLICY_FILE_NAME = "entitlement-policy.yaml";

    public static Map<String, Policy> createPluginPolicies(Collection<PluginData> pluginData, Map<String, String> pluginPolicyPatches, String version) throws IOException {
        HashMap<String, Policy> pluginPolicies = new HashMap<String, Policy>(pluginData.size());
        for (PluginData entry : pluginData) {
            Path pluginRoot = entry.pluginPath();
            Path policyFile = pluginRoot.resolve(POLICY_FILE_NAME);
            String pluginName = pluginRoot.getFileName().toString();
            Set<String> moduleNames = PolicyUtils.getModuleNames(pluginRoot, entry.isModular());
            Policy pluginPolicyPatch = PolicyUtils.parseEncodedPolicyIfExists(pluginPolicyPatches.get(pluginName), version, entry.isExternalPlugin(), pluginName, moduleNames);
            Policy pluginPolicy = PolicyUtils.parsePolicyIfExists(pluginName, policyFile, entry.isExternalPlugin());
            PolicyUtils.validatePolicyScopes(pluginName, pluginPolicy, moduleNames, policyFile.toString());
            pluginPolicies.put(pluginName, pluginPolicyPatch == null ? pluginPolicy : new Policy(pluginPolicy.name(), PolicyUtils.mergeScopes(pluginPolicy.scopes(), pluginPolicyPatch.scopes())));
        }
        return pluginPolicies;
    }

    public static Policy parseEncodedPolicyIfExists(String encodedPolicy, String version, boolean externalPlugin, String layerName, Set<String> moduleNames) {
        if (encodedPolicy != null) {
            try {
                VersionedPolicy versionedPolicy = PolicyUtils.decodeEncodedPolicy(encodedPolicy, layerName, externalPlugin);
                PolicyUtils.validatePolicyScopes(layerName, versionedPolicy.policy(), moduleNames, "<patch>");
                if (versionedPolicy.versions().isEmpty() || versionedPolicy.versions().contains(version)) {
                    logger.info("Using policy patch for layer [{}]", new Object[]{layerName});
                    return versionedPolicy.policy();
                }
                logger.warn("Found a policy patch with version mismatch. The patch will not be applied. Layer [{}]; policy versions [{}]; current version [{}]", new Object[]{layerName, String.join((CharSequence)",", versionedPolicy.versions()), version});
            }
            catch (Exception ex) {
                logger.warn(Strings.format((String)"Found a policy patch with invalid content. The patch will not be applied. Layer [%s]", (Object[])new Object[]{layerName}), (Throwable)ex);
            }
        }
        return null;
    }

    static VersionedPolicy decodeEncodedPolicy(String base64String, String layerName, boolean isExternalPlugin) throws IOException {
        byte[] policyDefinition = Base64.getDecoder().decode(base64String);
        return new PolicyParser(new ByteArrayInputStream(policyDefinition), layerName, isExternalPlugin).parseVersionedPolicy();
    }

    private static void validatePolicyScopes(String layerName, Policy policy, Set<String> moduleNames, String policyLocation) {
        for (Scope scope : policy.scopes()) {
            if (moduleNames.contains(scope.moduleName())) continue;
            throw new IllegalStateException(Strings.format((String)"Invalid module name in policy: layer [%s] does not have module [%s]; available modules [%s]; policy path [%s]", (Object[])new Object[]{layerName, scope.moduleName(), String.join((CharSequence)", ", moduleNames), policyLocation}));
        }
    }

    private static Policy parsePolicyIfExists(String pluginName, Path policyFile, boolean isExternalPlugin) throws IOException {
        if (Files.exists(policyFile, new LinkOption[0])) {
            return new PolicyParser(Files.newInputStream(policyFile, StandardOpenOption.READ), pluginName, isExternalPlugin).parsePolicy();
        }
        return new Policy(pluginName, List.of());
    }

    private static Set<String> getModuleNames(Path pluginRoot, boolean isModular) {
        if (isModular) {
            ModuleFinder moduleFinder = ModuleFinder.of(pluginRoot);
            Set<ModuleReference> moduleReferences = moduleFinder.findAll();
            return moduleReferences.stream().map(mr -> mr.descriptor().name()).collect(Collectors.toUnmodifiableSet());
        }
        return Set.of("ALL-UNNAMED");
    }

    public static List<Scope> mergeScopes(List<Scope> mainScopes, List<Scope> additionalScopes) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        Map<String, List> additionalScopesMap = additionalScopes.stream().collect(Collectors.toMap(Scope::moduleName, Scope::entitlements));
        for (Scope scope : mainScopes) {
            List additionalEntitlements = additionalScopesMap.remove(scope.moduleName());
            if (additionalEntitlements == null) {
                result.add(scope);
                continue;
            }
            result.add(new Scope(scope.moduleName(), PolicyUtils.mergeEntitlements(scope.entitlements(), additionalEntitlements)));
        }
        for (Map.Entry entry : additionalScopesMap.entrySet()) {
            result.add(new Scope((String)entry.getKey(), (List)entry.getValue()));
        }
        return result;
    }

    static List<Entitlement> mergeEntitlements(List<Entitlement> a, List<Entitlement> b) {
        Map entitlementMap = a.stream().collect(Collectors.toMap((Function<Entitlement, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lorg/elasticsearch/entitlement/runtime/policy/entitlements/Entitlement;)Ljava/lang/Class;)(), Function.identity()));
        for (Entitlement entitlement : b) {
            entitlementMap.merge(entitlement.getClass(), entitlement, PolicyUtils::mergeEntitlement);
        }
        return entitlementMap.values().stream().toList();
    }

    static Entitlement mergeEntitlement(Entitlement entitlement1, Entitlement entitlement2) {
        Entitlement entitlement = entitlement1;
        Objects.requireNonNull(entitlement);
        Entitlement entitlement3 = entitlement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FilesEntitlement.class, WriteSystemPropertiesEntitlement.class}, (Object)entitlement3, n)) {
            case 0 -> {
                FilesEntitlement e = (FilesEntitlement)entitlement3;
                yield PolicyUtils.merge(e, (FilesEntitlement)entitlement2);
            }
            case 1 -> {
                WriteSystemPropertiesEntitlement e = (WriteSystemPropertiesEntitlement)entitlement3;
                yield PolicyUtils.merge(e, (WriteSystemPropertiesEntitlement)entitlement2);
            }
            default -> entitlement1;
        };
    }

    private static FilesEntitlement merge(FilesEntitlement a, FilesEntitlement b) {
        return new FilesEntitlement(Stream.concat(a.filesData().stream(), b.filesData().stream()).distinct().toList());
    }

    private static WriteSystemPropertiesEntitlement merge(WriteSystemPropertiesEntitlement a, WriteSystemPropertiesEntitlement b) {
        return new WriteSystemPropertiesEntitlement(Stream.concat(a.properties().stream(), b.properties().stream()).collect(Collectors.toUnmodifiableSet()));
    }

    public record PluginData(Path pluginPath, boolean isModular, boolean isExternalPlugin) {
        public PluginData {
            Objects.requireNonNull(pluginPath);
        }
    }
}

