/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import org.elasticsearch.entitlement.runtime.policy.FileAccessTreeComparison;

class CaseInsensitiveComparison
extends FileAccessTreeComparison {
    CaseInsensitiveComparison(char separatorChar) {
        super(CaseInsensitiveComparison::caseInsensitiveCharacterComparator, separatorChar);
    }

    private static int caseInsensitiveCharacterComparator(char c1, char c2) {
        return Character.compare(Character.toLowerCase(c1), Character.toLowerCase(c2));
    }

    @Override
    protected boolean pathStartsWith(String pathString, String pathPrefix) {
        return pathString.regionMatches(true, 0, pathPrefix, 0, pathPrefix.length());
    }

    @Override
    protected boolean pathsAreEqual(String path1, String path2) {
        return path1.equalsIgnoreCase(path2);
    }
}

