/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.initialization;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.entitlement.bootstrap.EntitlementBootstrap;
import org.elasticsearch.entitlement.bridge.EntitlementChecker;
import org.elasticsearch.entitlement.initialization.DynamicInstrumentation;
import org.elasticsearch.entitlement.initialization.EntitlementCheckerUtils;
import org.elasticsearch.entitlement.initialization.FilesEntitlementsValidation;
import org.elasticsearch.entitlement.initialization.HardcodedEntitlements;
import org.elasticsearch.entitlement.runtime.api.ElasticsearchEntitlementChecker;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.PolicyChecker;
import org.elasticsearch.entitlement.runtime.policy.PolicyCheckerImpl;
import org.elasticsearch.entitlement.runtime.policy.PolicyManager;

public class EntitlementInitialization {
    private static final Module ENTITLEMENTS_MODULE = PolicyManager.class.getModule();
    private static ElasticsearchEntitlementChecker manager;

    public static EntitlementChecker checker() {
        return manager;
    }

    public static void initialize(Instrumentation inst) throws Exception {
        manager = EntitlementInitialization.initChecker();
        boolean verifyBytecode = Booleans.parseBoolean((String)System.getProperty("es.entitlements.verify_bytecode", "false"));
        if (verifyBytecode) {
            EntitlementInitialization.ensureClassesSensitiveToVerificationAreInitialized();
        }
        DynamicInstrumentation.initialize(inst, EntitlementCheckerUtils.getVersionSpecificCheckerClass(EntitlementChecker.class, Runtime.version().feature()), verifyBytecode);
    }

    private static void ensureClassesSensitiveToVerificationAreInitialized() {
        Set<String> classesToInitialize = Set.of("sun.net.www.protocol.http.HttpURLConnection");
        for (String className : classesToInitialize) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException unexpected) {
                throw new AssertionError((Object)unexpected);
            }
        }
    }

    private static ElasticsearchEntitlementChecker initChecker() {
        Constructor<?> constructor;
        PolicyCheckerImpl policyChecker = EntitlementInitialization.createPolicyChecker();
        Class<?> clazz = EntitlementCheckerUtils.getVersionSpecificCheckerClass(ElasticsearchEntitlementChecker.class, Runtime.version().feature());
        try {
            constructor = clazz.getConstructor(PolicyChecker.class);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("entitlement impl is missing required constructor: [" + clazz.getName() + "]", e);
        }
        try {
            return (ElasticsearchEntitlementChecker)constructor.newInstance(policyChecker);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static PolicyCheckerImpl createPolicyChecker() {
        EntitlementBootstrap.BootstrapArgs bootstrapArgs = EntitlementBootstrap.bootstrapArgs();
        Map<String, Policy> pluginPolicies = bootstrapArgs.pluginPolicies();
        PathLookup pathLookup = bootstrapArgs.pathLookup();
        FilesEntitlementsValidation.validate(pluginPolicies, pathLookup);
        PolicyManager policyManager = new PolicyManager(HardcodedEntitlements.serverPolicy(pathLookup.pidFile(), bootstrapArgs.serverPolicyPatch()), HardcodedEntitlements.agentEntitlements(), pluginPolicies, EntitlementBootstrap.bootstrapArgs().scopeResolver(), EntitlementBootstrap.bootstrapArgs().sourcePaths(), pathLookup);
        return new PolicyCheckerImpl(bootstrapArgs.suppressFailureLogPackages(), ENTITLEMENTS_MODULE, policyManager, bootstrapArgs.pathLookup());
    }
}

