/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo.geometry;

import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.geometry.GeometryUtils;
import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.ShapeType;

public class Circle
implements Geometry {
    public static final Circle EMPTY = new Circle();
    private final double lat;
    private final double lon;
    private final double radiusMeters;

    private Circle() {
        this.lat = 0.0;
        this.lon = 0.0;
        this.radiusMeters = -1.0;
    }

    public Circle(double lat, double lon, double radiusMeters) {
        this.lat = lat;
        this.lon = lon;
        this.radiusMeters = radiusMeters;
        if (radiusMeters < 0.0) {
            throw new IllegalArgumentException("Circle radius [" + radiusMeters + "] cannot be negative");
        }
        GeometryUtils.checkLatitude(lat);
        GeometryUtils.checkLongitude(lon);
    }

    @Override
    public ShapeType type() {
        return ShapeType.CIRCLE;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public double getRadiusMeters() {
        return this.radiusMeters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Circle circle = (Circle)o;
        if (Double.compare(circle.lat, this.lat) != 0) {
            return false;
        }
        if (Double.compare(circle.lon, this.lon) != 0) {
            return false;
        }
        return Double.compare(circle.radiusMeters, this.radiusMeters) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.lat);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radiusMeters);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public <T> T visit(GeometryVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        return this.radiusMeters < 0.0;
    }

    public String toString() {
        return "lat=" + this.lat + ", lon=" + this.lon + ", radius=" + this.radiusMeters;
    }
}

