/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo.geometry;

public final class GeometryUtils {
    static final double MIN_LON_INCL = -180.0;
    static final double MAX_LON_INCL = 180.0;
    static final double MIN_LAT_INCL = -90.0;
    static final double MAX_LAT_INCL = 90.0;

    private GeometryUtils() {
    }

    static void checkLatitude(double latitude) {
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("invalid latitude " + latitude + "; must be between " + -90.0 + " and " + 90.0);
        }
    }

    static void checkLongitude(double longitude) {
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("invalid longitude " + longitude + "; must be between " + -180.0 + " and " + 180.0);
        }
    }

    public static double checkAltitude(boolean ignoreZValue, double zValue) {
        if (!ignoreZValue) {
            throw new IllegalArgumentException("found Z value [" + zValue + "] but [ignore_z_value] parameter is [" + ignoreZValue + "]");
        }
        return zValue;
    }
}

