/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.Parser;
import org.elasticsearch.hadoop.serialization.ParsingUtils;
import org.elasticsearch.hadoop.serialization.builder.ValueReader;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonParser;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayInputStream;
import org.elasticsearch.hadoop.util.IOUtils;

public class ScrollReader {
    private static final Log log = LogFactory.getLog(ScrollReader.class);
    private Parser parser;
    private final ValueReader reader;
    private final Map<String, FieldType> esMapping;
    private final boolean trace = log.isTraceEnabled();
    private static final String[] HITS = new String[]{"hits"};
    private static final String[] ID = new String[]{"_id"};
    private static final String[] FIELDS = new String[]{"fields"};
    private static final String[] SOURCE = new String[]{"_source"};
    private static final String[] TOTAL = new String[]{"hits", "total"};

    public ScrollReader(ValueReader reader, Field rootField) {
        this.reader = reader;
        this.esMapping = Field.toLookupMap(rootField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> read(InputStream content) throws IOException {
        Assert.notNull(content);
        if (log.isTraceEnabled()) {
            BytesArray copy = IOUtils.asBytes(content);
            content = new FastByteArrayInputStream(copy);
            log.trace((Object)("About to parse scroll content " + copy));
        }
        this.parser = new JacksonJsonParser(content);
        try {
            List<Object[]> list = this.read();
            return list;
        }
        finally {
            this.parser.close();
        }
    }

    private List<Object[]> read() {
        if (this.hits() == 0L) {
            return null;
        }
        Parser.Token token = ParsingUtils.seek(this.parser, HITS);
        Assert.isTrue(token == Parser.Token.START_ARRAY, "invalid response");
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        token = this.parser.nextToken();
        while (token != Parser.Token.END_ARRAY) {
            results.add(this.readHit());
            token = this.parser.nextToken();
        }
        return results;
    }

    private Object[] readHit() {
        Parser.Token t = this.parser.currentToken();
        Assert.isTrue(t == Parser.Token.START_OBJECT, "expected object, found " + (Object)((Object)t));
        Assert.notNull((Object)ParsingUtils.seek(this.parser, ID), "no id found");
        Object[] result = new Object[2];
        result[0] = this.parser.text();
        Parser.Token seek = ParsingUtils.seek(this.parser, SOURCE, FIELDS);
        Map map = result[1] = seek == null ? Collections.emptyMap() : this.read(t, null);
        if (this.trace) {
            log.trace((Object)String.format("Read hit result [%s]=[%s]", result[0], result[1]));
        }
        return result;
    }

    private long hits() {
        ParsingUtils.seek(this.parser, TOTAL);
        long hits = this.parser.longValue();
        return hits;
    }

    protected Object read(Parser.Token t, String fieldMapping) {
        if (t == Parser.Token.START_OBJECT) {
            return this.map(fieldMapping);
        }
        if (t == Parser.Token.START_ARRAY) {
            return this.list(fieldMapping);
        }
        FieldType esType = this.mapping(fieldMapping);
        if (t.isValue()) {
            return this.parseValue(esType);
        }
        return null;
    }

    private Object parseValue(FieldType esType) {
        Object obj = this.parser.currentToken() == Parser.Token.VALUE_NULL ? null : this.reader.readValue(this.parser, this.parser.text(), esType);
        this.parser.nextToken();
        return obj;
    }

    protected Object list(String fieldMapping) {
        Parser.Token t = this.parser.currentToken();
        if (t == null) {
            t = this.parser.nextToken();
        }
        if (t == Parser.Token.START_ARRAY) {
            t = this.parser.nextToken();
        }
        Object array = this.reader.createArray(this.mapping(fieldMapping));
        ArrayList<Object> content = new ArrayList<Object>(1);
        while (this.parser.currentToken() != Parser.Token.END_ARRAY) {
            content.add(this.read(this.parser.currentToken(), fieldMapping));
        }
        this.parser.nextToken();
        array = this.reader.addToArray(array, content);
        return array;
    }

    protected Object map(String fieldMapping) {
        Parser.Token t = this.parser.currentToken();
        if (t == null) {
            t = this.parser.nextToken();
        }
        if (t == Parser.Token.START_OBJECT) {
            t = this.parser.nextToken();
        }
        Object map = this.reader.createMap();
        while (this.parser.currentToken() != Parser.Token.END_OBJECT) {
            String currentName = this.parser.currentName();
            String nodeMapping = fieldMapping;
            nodeMapping = nodeMapping != null ? fieldMapping + "." + currentName : currentName;
            Object fieldName = this.reader.readValue(this.parser, currentName, FieldType.STRING);
            this.reader.addToMap(map, fieldName, this.read(this.parser.nextToken(), nodeMapping));
        }
        this.parser.nextToken();
        return map;
    }

    private FieldType mapping(String fieldMapping) {
        FieldType esType = this.esMapping.get(fieldMapping);
        if (esType != null) {
            return esType;
        }
        Parser.Token currentToken = this.parser.currentToken();
        if (!currentToken.isValue()) {
            return FieldType.OBJECT;
        }
        block0 : switch (currentToken) {
            case VALUE_NULL: {
                esType = FieldType.NULL;
                break;
            }
            case VALUE_BOOLEAN: {
                esType = FieldType.BOOLEAN;
                break;
            }
            case VALUE_STRING: {
                esType = FieldType.STRING;
                break;
            }
            case VALUE_NUMBER: {
                Parser.NumberType numberType = this.parser.numberType();
                switch (numberType) {
                    case INT: {
                        esType = FieldType.INTEGER;
                        break block0;
                    }
                    case LONG: {
                        esType = FieldType.LONG;
                        break block0;
                    }
                    case FLOAT: {
                        esType = FieldType.FLOAT;
                        break block0;
                    }
                    case DOUBLE: {
                        esType = FieldType.DOUBLE;
                        break block0;
                    }
                    case BIG_DECIMAL: {
                        throw new UnsupportedOperationException();
                    }
                    case BIG_INTEGER: {
                        throw new UnsupportedOperationException();
                    }
                }
                break;
            }
        }
        return esType;
    }
}

