/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;

public abstract class StringUtils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String EMPTY = "";

    public static boolean hasLength(CharSequence sequence) {
        return sequence != null && sequence.length() > 0;
    }

    public static boolean hasText(CharSequence sequence) {
        if (!StringUtils.hasLength(sequence)) {
            return false;
        }
        int length = sequence.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(sequence.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static List<String> tokenize(String string) {
        return StringUtils.tokenize(string, ",");
    }

    public static List<String> tokenize(String string, String delimiters) {
        return StringUtils.tokenize(string, delimiters, true, true);
    }

    public static List<String> tokenize(String string, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (string == null) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(string, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static String concatenate(Collection<?> list, String delimiter) {
        if (list == null || list.isEmpty()) {
            return EMPTY;
        }
        if (delimiter == null) {
            delimiter = EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : list) {
            sb.append(object.toString());
            sb.append(delimiter);
        }
        sb.setLength(sb.length() - delimiter.length());
        return sb.toString();
    }

    public static String concatenate(Object[] array, String delimiter) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        if (delimiter == null) {
            delimiter = EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String deleteWhitespace(CharSequence sequence) {
        if (!StringUtils.hasLength(sequence)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(sequence.length());
        for (int i = 0; i < sequence.length(); ++i) {
            char currentChar = sequence.charAt(i);
            if (Character.isWhitespace(currentChar)) continue;
            sb.append(currentChar);
        }
        return sb.length() == sequence.length() ? ((Object)sequence).toString() : sb.toString();
    }

    public static String asUTFString(byte[] content) {
        return StringUtils.asUTFString(content, content.length);
    }

    public static String asUTFString(byte[] content, int length) {
        return content == null || length == 0 ? EMPTY : new String(content, 0, length, UTF_8);
    }

    public static byte[] toUTF(String string) {
        return string.getBytes(UTF_8);
    }

    public static int levenshteinDistance(CharSequence one, CharSequence another, int threshold) {
        int n = one.length();
        int m = another.length();
        if (n == 0) {
            return m <= threshold ? m : -1;
        }
        if (m == 0) {
            return n <= threshold ? n : -1;
        }
        if (n > m) {
            CharSequence tmp = one;
            one = another;
            another = tmp;
            n = m;
            m = another.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        int boundary = Math.min(n, threshold) + 1;
        for (int i = 0; i < boundary; ++i) {
            p[i] = i;
        }
        Arrays.fill(p, boundary, p.length, Integer.MAX_VALUE);
        Arrays.fill(d, Integer.MAX_VALUE);
        for (int j = 1; j <= m; ++j) {
            int max;
            char t_j = another.charAt(j - 1);
            d[0] = j;
            int min = Math.max(1, j - threshold);
            int n2 = max = j > Integer.MAX_VALUE - threshold ? n : Math.min(n, j + threshold);
            if (min > max) {
                return -1;
            }
            if (min > 1) {
                d[min - 1] = Integer.MAX_VALUE;
            }
            for (int i = min; i <= max; ++i) {
                d[i] = one.charAt(i - 1) == t_j ? p[i - 1] : 1 + Math.min(Math.min(d[i - 1], p[i]), p[i - 1]);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        if (p[n] <= threshold) {
            return p[n];
        }
        return -1;
    }

    public static List<String> findSimiliar(CharSequence match, Collection<String> potential) {
        ArrayList<String> list = new ArrayList<String>(3);
        int maxDistance = 2;
        for (String string : potential) {
            int dist = StringUtils.levenshteinDistance(match, string, maxDistance);
            if (dist < 0) continue;
            if (dist < maxDistance) {
                maxDistance = dist;
                list.clear();
                list.add(string);
                continue;
            }
            if (dist != maxDistance) continue;
            list.add(string);
        }
        return list;
    }

    public static String sanitizeResource(String resource) {
        String res = resource.trim();
        if (res.startsWith("/")) {
            res = res.substring(1);
        }
        if (res.endsWith("/")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public static String escapeUri(String uri) {
        try {
            return URIUtil.encodePathQuery((String)uri);
        }
        catch (URIException ex) {
            throw new EsHadoopIllegalArgumentException("Cannot escape uri" + uri);
        }
    }
}

