/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.core.Assert;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class AbstractDefaultParamsExtractor
implements FieldExtractor,
SettingsAware {
    private Map<String, FieldExtractor> params = new LinkedHashMap<String, FieldExtractor>();
    protected Settings settings;

    @Override
    public String field(Object target) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, FieldExtractor> entry : this.params.entrySet()) {
            sb.append("\"");
            sb.append(entry.getKey());
            sb.append("\":\"");
            sb.append(entry.getValue().field(target));
            sb.append("\",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
        String paramString = settings.getUpdateScriptParams();
        List<String> fields = StringUtils.tokenize(paramString);
        for (String string : fields) {
            List<String> param = StringUtils.tokenize(string, ":");
            Assert.isTrue((param.size() == 2 ? 1 : 0) != 0, (String)("Invalid param definition " + string));
            this.params.put(param.get(0), this.createFieldExtractor(param.get(1)));
        }
    }

    protected abstract FieldExtractor createFieldExtractor(String var1);
}

