/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.StringUtils;

public class ScrollQuery
implements Iterator<Object>,
Closeable,
StatsAware {
    private RestRepository repository;
    private String scrollId;
    private List<Object[]> batch = Collections.emptyList();
    private boolean finished = false;
    private int batchIndex = 0;
    private long read = 0L;
    private long size;
    private final ScrollReader reader;
    private final Stats stats = new Stats();
    private boolean closed = false;
    private boolean initialized = false;
    private String query;
    private BytesArray body;

    ScrollQuery(RestRepository client, String query, BytesArray body, long size, ScrollReader reader) {
        this.repository = client;
        this.size = size;
        this.reader = reader;
        this.query = query;
        this.body = body;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.finished = true;
            this.batch = Collections.emptyList();
            if (StringUtils.hasText(this.scrollId)) {
                this.repository.getRestClient().deleteScroll(this.scrollId);
            }
        }
    }

    @Override
    public boolean hasNext() {
        ScrollReader.Scroll scroll;
        if (this.finished) {
            return false;
        }
        if (!this.initialized) {
            this.initialized = true;
            try {
                scroll = this.repository.scroll(this.query, this.body, this.reader);
                this.size = this.size < 1L ? scroll.getTotalHits() : this.size;
                this.scrollId = scroll.getScrollId();
                this.batch = scroll.getHits();
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalStateException(String.format("Cannot create scroll for query [%s/%s]", this.query, this.body), ex);
            }
            this.body = null;
            this.query = null;
        }
        if (this.batch.isEmpty() || this.batchIndex >= this.batch.size()) {
            if (this.read >= this.size) {
                this.finished = true;
                return false;
            }
            try {
                scroll = this.repository.scroll(this.scrollId, this.reader);
                this.scrollId = scroll.getScrollId();
                this.batch = scroll.getHits();
            }
            catch (IOException ex) {
                throw new EsHadoopIllegalStateException("Cannot retrieve scroll [" + this.scrollId + "]", ex);
            }
            this.read += (long)this.batch.size();
            this.stats.docsReceived += (long)this.batch.size();
            if (this.batch.isEmpty()) {
                this.finished = true;
                return false;
            }
            this.batchIndex = 0;
        }
        return true;
    }

    public long getSize() {
        return this.size;
    }

    public long getRead() {
        return this.read;
    }

    @Override
    public Object[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more documents available");
        }
        return this.batch.get(this.batchIndex++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("read-only operator");
    }

    @Override
    public Stats stats() {
        return new Stats(this.stats);
    }

    public RestRepository repository() {
        return this.repository;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ScrollQuery [scrollId=").append(this.scrollId).append("]");
        return builder.toString();
    }
}

