/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.elasticsearch.hadoop.mr.EsInputFormat;
import org.elasticsearch.hadoop.mr.compat.CompatHandler;

public class EsPigInputFormat
extends EsInputFormat<String, Object> {
    @Override
    public AbstractPigEsInputRecordReader createRecordReader(InputSplit split, TaskAttemptContext context) {
        return this.isOutputAsJson(CompatHandler.taskAttemptContext(context).getConfiguration()) ? new PigJsonEsInputRecordReader() : new PigEsInputRecordReader();
    }

    @Override
    public AbstractPigEsInputRecordReader getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf job, Reporter reporter) {
        return this.isOutputAsJson((Configuration)job) ? new PigJsonEsInputRecordReader(split, (Configuration)job, reporter) : new PigEsInputRecordReader(split, (Configuration)job, reporter);
    }

    protected static class PigJsonEsInputRecordReader
    extends AbstractPigEsInputRecordReader<String> {
        public PigJsonEsInputRecordReader() {
        }

        public PigJsonEsInputRecordReader(org.apache.hadoop.mapred.InputSplit split, Configuration job, Reporter reporter) {
            super(split, job, reporter);
        }

        @Override
        public String createValue() {
            return "";
        }

        @Override
        protected String setCurrentValue(String hadoopValue, Object object) {
            return object.toString();
        }
    }

    protected static class PigEsInputRecordReader
    extends AbstractPigEsInputRecordReader<Map> {
        public PigEsInputRecordReader() {
        }

        public PigEsInputRecordReader(org.apache.hadoop.mapred.InputSplit split, Configuration job, Reporter reporter) {
            super(split, job, reporter);
        }

        @Override
        public Map createValue() {
            return new LinkedHashMap();
        }

        @Override
        protected Map setCurrentValue(Map hadoopValue, Object object) {
            Map map = (Map)object;
            if (hadoopValue != null) {
                hadoopValue.clear();
                hadoopValue.putAll(map);
            }
            return hadoopValue;
        }
    }

    protected static abstract class AbstractPigEsInputRecordReader<V>
    extends EsInputFormat.EsInputRecordReader<String, V> {
        public AbstractPigEsInputRecordReader() {
        }

        public AbstractPigEsInputRecordReader(org.apache.hadoop.mapred.InputSplit split, Configuration job, Reporter reporter) {
            super(split, job, reporter);
        }

        @Override
        public String createKey() {
            return "";
        }

        @Override
        protected String setCurrentKey(String hadoopKey, Object object) {
            return object.toString();
        }
    }
}

