/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mvel;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.math.UnboxedMathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.MapVariableResolverFactory;

public class MvelScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    private final ParserConfiguration parserConfiguration = new ParserConfiguration();

    @Inject
    public MvelScriptEngineService(Settings settings) {
        super(settings);
        this.parserConfiguration.addPackageImport("java.util");
        this.parserConfiguration.addPackageImport("gnu.trove");
        this.parserConfiguration.addPackageImport("org.joda");
        this.parserConfiguration.addImport("time", MVEL.getStaticMethod(System.class, (String)"currentTimeMillis", (Class[])new Class[0]));
        for (Method m : UnboxedMathUtils.class.getMethods()) {
            if ((m.getModifiers() & 8) <= 0) continue;
            this.parserConfiguration.addImport(m.getName(), m);
        }
    }

    public String[] types() {
        return new String[]{"mvel"};
    }

    public String[] extensions() {
        return new String[]{"mvel"};
    }

    public boolean sandboxed() {
        return false;
    }

    public Object compile(String script) {
        return MVEL.compileExpression((String)script, (ParserContext)new ParserContext(this.parserConfiguration));
    }

    public ExecutableScript executable(Object compiledScript, @Nullable Map<String, Object> vars) {
        return new MvelExecutableScript(compiledScript, vars);
    }

    public SearchScript search(Object compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        return new MvelSearchScript(compiledScript, lookup, vars);
    }

    public Object execute(Object compiledScript, Map<String, Object> vars) {
        return MVEL.executeExpression((Object)compiledScript, vars);
    }

    public Object unwrap(Object value) {
        return value;
    }

    public void close() {
    }

    public void scriptRemoved(@Nullable CompiledScript compiledScript) {
    }

    public static class MvelSearchScript
    implements SearchScript {
        private final ExecutableStatement script;
        private final SearchLookup lookup;
        private final MapVariableResolverFactory resolver;
        private Scorer scorer;

        public MvelSearchScript(Object script, SearchLookup lookup, Map<String, Object> vars) {
            this.script = (ExecutableStatement)script;
            this.lookup = lookup;
            this.resolver = vars != null ? new MapVariableResolverFactory(vars) : new MapVariableResolverFactory(new HashMap());
            for (Map.Entry entry : lookup.asMap().entrySet()) {
                this.resolver.createVariable((String)entry.getKey(), entry.getValue());
            }
        }

        public void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        public void setNextReader(AtomicReaderContext context) {
            this.lookup.setNextReader(context);
        }

        public void setNextDocId(int doc) {
            this.lookup.setNextDocId(doc);
        }

        public void setNextVar(String name, Object value) {
            this.resolver.createVariable(name, value);
        }

        public void setNextSource(Map<String, Object> source) {
            this.lookup.source().setNextSource(source);
        }

        public Object run() {
            try {
                if (this.scorer != null) {
                    this.resolver.createVariable("_score", (Object)Float.valueOf(this.scorer.score()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not get score", e);
            }
            return this.script.getValue(null, (VariableResolverFactory)this.resolver);
        }

        public float runAsFloat() {
            return ((Number)this.run()).floatValue();
        }

        public long runAsLong() {
            return ((Number)this.run()).longValue();
        }

        public double runAsDouble() {
            return ((Number)this.run()).doubleValue();
        }

        public Object unwrap(Object value) {
            return value;
        }
    }

    public static class MvelExecutableScript
    implements ExecutableScript {
        private final ExecutableStatement script;
        private final MapVariableResolverFactory resolver;

        public MvelExecutableScript(Object script, Map vars) {
            this.script = (ExecutableStatement)script;
            this.resolver = vars != null ? new MapVariableResolverFactory(vars) : new MapVariableResolverFactory(new HashMap());
        }

        public void setNextVar(String name, Object value) {
            this.resolver.createVariable(name, value);
        }

        public Object run() {
            return this.script.getValue(null, (VariableResolverFactory)this.resolver);
        }

        public Object unwrap(Object value) {
            return value;
        }
    }
}

