/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ObjectMapperListener;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.plugin.mapper.attachments.tika.TikaInstance;

public class AttachmentMapper
implements Mapper {
    public static final String CONTENT_TYPE = "attachment";
    private final String name;
    private final ContentPath.Type pathType;
    private final int defaultIndexedChars;
    private final StringFieldMapper contentMapper;
    private final DateFieldMapper dateMapper;
    private final StringFieldMapper authorMapper;
    private final StringFieldMapper titleMapper;
    private final StringFieldMapper nameMapper;
    private final StringFieldMapper keywordsMapper;
    private final StringFieldMapper contentTypeMapper;

    public AttachmentMapper(String name, ContentPath.Type pathType, int defaultIndexedChars, StringFieldMapper contentMapper, DateFieldMapper dateMapper, StringFieldMapper titleMapper, StringFieldMapper nameMapper, StringFieldMapper authorMapper, StringFieldMapper keywordsMapper, StringFieldMapper contentTypeMapper) {
        this.name = name;
        this.pathType = pathType;
        this.defaultIndexedChars = defaultIndexedChars;
        this.contentMapper = contentMapper;
        this.dateMapper = dateMapper;
        this.titleMapper = titleMapper;
        this.nameMapper = nameMapper;
        this.authorMapper = authorMapper;
        this.keywordsMapper = keywordsMapper;
        this.contentTypeMapper = contentTypeMapper;
    }

    public String name() {
        return this.name;
    }

    public void parse(ParseContext context) throws IOException {
        String parsedContent;
        byte[] content = null;
        String contentType = null;
        int indexedChars = this.defaultIndexedChars;
        String name = null;
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            content = parser.binaryValue();
        } else {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if ("content".equals(currentFieldName)) {
                        content = parser.binaryValue();
                        continue;
                    }
                    if ("_content_type".equals(currentFieldName)) {
                        contentType = parser.text();
                        continue;
                    }
                    if (!"_name".equals(currentFieldName)) continue;
                    name = parser.text();
                    continue;
                }
                if (token != XContentParser.Token.VALUE_NUMBER || !"_indexed_chars".equals(currentFieldName) && !"_indexedChars".equals(currentFieldName)) continue;
                indexedChars = parser.intValue();
            }
        }
        if (content == null) {
            throw new MapperParsingException("No content is provided.");
        }
        Metadata metadata = new Metadata();
        if (contentType != null) {
            metadata.add("Content-Type", contentType);
        }
        if (name != null) {
            metadata.add("resourceName", name);
        }
        try {
            parsedContent = TikaInstance.tika().parseToString((InputStream)new BytesStreamInput(content, false), metadata, indexedChars);
        }
        catch (TikaException e) {
            throw new MapperParsingException("Failed to extract [" + indexedChars + "] characters of text for [" + name + "]", (Throwable)e);
        }
        context.externalValue((Object)parsedContent);
        this.contentMapper.parse(context);
        context.externalValue((Object)name);
        this.nameMapper.parse(context);
        context.externalValue((Object)metadata.get(Metadata.DATE));
        this.dateMapper.parse(context);
        context.externalValue((Object)metadata.get("title"));
        this.titleMapper.parse(context);
        context.externalValue((Object)metadata.get("Author"));
        this.authorMapper.parse(context);
        context.externalValue((Object)metadata.get("Keywords"));
        this.keywordsMapper.parse(context);
        context.externalValue((Object)metadata.get("Content-Type"));
        this.contentTypeMapper.parse(context);
    }

    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public void traverse(FieldMapperListener fieldMapperListener) {
        this.contentMapper.traverse(fieldMapperListener);
        this.dateMapper.traverse(fieldMapperListener);
        this.titleMapper.traverse(fieldMapperListener);
        this.nameMapper.traverse(fieldMapperListener);
        this.authorMapper.traverse(fieldMapperListener);
        this.keywordsMapper.traverse(fieldMapperListener);
        this.contentTypeMapper.traverse(fieldMapperListener);
    }

    public void traverse(ObjectMapperListener objectMapperListener) {
    }

    public void close() {
        this.contentMapper.close();
        this.dateMapper.close();
        this.titleMapper.close();
        this.nameMapper.close();
        this.authorMapper.close();
        this.keywordsMapper.close();
        this.contentTypeMapper.close();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field("type", CONTENT_TYPE);
        builder.field("path", this.pathType.name().toLowerCase());
        builder.startObject("fields");
        this.contentMapper.toXContent(builder, params);
        this.authorMapper.toXContent(builder, params);
        this.titleMapper.toXContent(builder, params);
        this.nameMapper.toXContent(builder, params);
        this.dateMapper.toXContent(builder, params);
        this.keywordsMapper.toXContent(builder, params);
        this.contentTypeMapper.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (fieldName.equals("path")) {
                    builder.pathType(TypeParsers.parsePathType((String)name, (String)fieldNode.toString()));
                    continue;
                }
                if (!fieldName.equals("fields")) continue;
                Map fieldsNode = (Map)fieldNode;
                for (Map.Entry entry1 : fieldsNode.entrySet()) {
                    String propName = (String)entry1.getKey();
                    Object propNode = entry1.getValue();
                    if (name.equals(propName)) {
                        builder.content((StringFieldMapper.Builder)parserContext.typeParser("string").parse(name, (Map)propNode, parserContext));
                        continue;
                    }
                    if ("date".equals(propName)) {
                        builder.date((DateFieldMapper.Builder)parserContext.typeParser("date").parse("date", (Map)propNode, parserContext));
                        continue;
                    }
                    if ("title".equals(propName)) {
                        builder.title((StringFieldMapper.Builder)parserContext.typeParser("string").parse("title", (Map)propNode, parserContext));
                        continue;
                    }
                    if ("name".equals(propName)) {
                        builder.name((StringFieldMapper.Builder)parserContext.typeParser("string").parse("name", (Map)propNode, parserContext));
                        continue;
                    }
                    if ("author".equals(propName)) {
                        builder.author((StringFieldMapper.Builder)parserContext.typeParser("string").parse("author", (Map)propNode, parserContext));
                        continue;
                    }
                    if ("keywords".equals(propName)) {
                        builder.keywords((StringFieldMapper.Builder)parserContext.typeParser("string").parse("keywords", (Map)propNode, parserContext));
                        continue;
                    }
                    if (!"content_type".equals(propName)) continue;
                    builder.contentType((StringFieldMapper.Builder)parserContext.typeParser("string").parse("content_type", (Map)propNode, parserContext));
                }
            }
            return builder;
        }
    }

    public static class Builder
    extends Mapper.Builder<Builder, AttachmentMapper> {
        private ContentPath.Type pathType = Defaults.PATH_TYPE;
        private Integer defaultIndexedChars = null;
        private StringFieldMapper.Builder contentBuilder;
        private StringFieldMapper.Builder titleBuilder = MapperBuilders.stringField((String)"title");
        private StringFieldMapper.Builder nameBuilder = MapperBuilders.stringField((String)"name");
        private StringFieldMapper.Builder authorBuilder = MapperBuilders.stringField((String)"author");
        private StringFieldMapper.Builder keywordsBuilder = MapperBuilders.stringField((String)"keywords");
        private DateFieldMapper.Builder dateBuilder = MapperBuilders.dateField((String)"date");
        private StringFieldMapper.Builder contentTypeBuilder = MapperBuilders.stringField((String)"content_type");

        public Builder(String name) {
            super(name);
            this.builder = this;
            this.contentBuilder = MapperBuilders.stringField((String)name);
        }

        public Builder pathType(ContentPath.Type pathType) {
            this.pathType = pathType;
            return this;
        }

        public Builder defaultIndexedChars(int defaultIndexedChars) {
            this.defaultIndexedChars = defaultIndexedChars;
            return this;
        }

        public Builder content(StringFieldMapper.Builder content) {
            this.contentBuilder = content;
            return this;
        }

        public Builder date(DateFieldMapper.Builder date) {
            this.dateBuilder = date;
            return this;
        }

        public Builder author(StringFieldMapper.Builder author) {
            this.authorBuilder = author;
            return this;
        }

        public Builder title(StringFieldMapper.Builder title) {
            this.titleBuilder = title;
            return this;
        }

        public Builder name(StringFieldMapper.Builder name) {
            this.nameBuilder = name;
            return this;
        }

        public Builder keywords(StringFieldMapper.Builder keywords) {
            this.keywordsBuilder = keywords;
            return this;
        }

        public Builder contentType(StringFieldMapper.Builder contentType) {
            this.contentTypeBuilder = contentType;
            return this;
        }

        public AttachmentMapper build(Mapper.BuilderContext context) {
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            StringFieldMapper contentMapper = this.contentBuilder.build(context);
            context.path().add(this.name);
            DateFieldMapper dateMapper = this.dateBuilder.build(context);
            StringFieldMapper authorMapper = this.authorBuilder.build(context);
            StringFieldMapper titleMapper = this.titleBuilder.build(context);
            StringFieldMapper nameMapper = this.nameBuilder.build(context);
            StringFieldMapper keywordsMapper = this.keywordsBuilder.build(context);
            StringFieldMapper contentTypeMapper = this.contentTypeBuilder.build(context);
            context.path().remove();
            context.path().pathType(origPathType);
            if (this.defaultIndexedChars != null && context.indexSettings() != null) {
                this.defaultIndexedChars = context.indexSettings().getAsInt("index.mapping.attachment.indexed_chars", Integer.valueOf(100000));
            }
            if (this.defaultIndexedChars == null) {
                this.defaultIndexedChars = 100000;
            }
            return new AttachmentMapper(this.name, this.pathType, this.defaultIndexedChars, contentMapper, dateMapper, titleMapper, nameMapper, authorMapper, keywordsMapper, contentTypeMapper);
        }
    }

    public static class Defaults {
        public static final ContentPath.Type PATH_TYPE = ContentPath.Type.FULL;
    }
}

