/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.jdk;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.elasticsearch.nativeaccess.VectorSimilarityFunctions;
import org.elasticsearch.nativeaccess.jdk.LinkerHelper;
import org.elasticsearch.nativeaccess.jdk.LinkerHelperUtil;
import org.elasticsearch.nativeaccess.lib.LoaderHelper;
import org.elasticsearch.nativeaccess.lib.VectorLibrary;

public final class JdkVectorLibrary
implements VectorLibrary {
    static final MethodHandle dot7u$mh;
    static final MethodHandle sqr7u$mh;
    static final VectorSimilarityFunctions INSTANCE;

    @Override
    public VectorSimilarityFunctions getVectorSimilarityFunctions() {
        return INSTANCE;
    }

    static {
        LoaderHelper.loadLibrary("vec");
        MethodHandle vecCaps$mh = LinkerHelper.downcallHandle("vec_caps", FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]), new Linker.Option[0]);
        try {
            int caps = vecCaps$mh.invokeExact();
            if (caps != 0) {
                if (caps == 2) {
                    dot7u$mh = LinkerHelper.downcallHandle("dot7u_2", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT), LinkerHelperUtil.critical());
                    sqr7u$mh = LinkerHelper.downcallHandle("sqr7u_2", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT), LinkerHelperUtil.critical());
                } else {
                    dot7u$mh = LinkerHelper.downcallHandle("dot7u", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT), LinkerHelperUtil.critical());
                    sqr7u$mh = LinkerHelper.downcallHandle("sqr7u", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT), LinkerHelperUtil.critical());
                }
                INSTANCE = new JdkVectorSimilarityFunctions();
            } else {
                dot7u$mh = null;
                sqr7u$mh = null;
                INSTANCE = null;
            }
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    private static final class JdkVectorSimilarityFunctions
    implements VectorSimilarityFunctions {
        static final MethodHandle DOT_HANDLE_7U;
        static final MethodHandle SQR_HANDLE_7U;

        private JdkVectorSimilarityFunctions() {
        }

        static int dotProduct7u(MemorySegment a, MemorySegment b, int length) {
            assert (length >= 0);
            if (a.byteSize() != b.byteSize()) {
                throw new IllegalArgumentException("dimensions differ: " + a.byteSize() + "!=" + b.byteSize());
            }
            if ((long)length > a.byteSize()) {
                throw new IllegalArgumentException("length: " + length + ", greater than vector dimensions: " + a.byteSize());
            }
            return JdkVectorSimilarityFunctions.dot7u(a, b, length);
        }

        static int squareDistance7u(MemorySegment a, MemorySegment b, int length) {
            assert (length >= 0);
            if (a.byteSize() != b.byteSize()) {
                throw new IllegalArgumentException("dimensions differ: " + a.byteSize() + "!=" + b.byteSize());
            }
            if ((long)length > a.byteSize()) {
                throw new IllegalArgumentException("length: " + length + ", greater than vector dimensions: " + a.byteSize());
            }
            return JdkVectorSimilarityFunctions.sqr7u(a, b, length);
        }

        private static int dot7u(MemorySegment a, MemorySegment b, int length) {
            try {
                return dot7u$mh.invokeExact(a, b, length);
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }

        private static int sqr7u(MemorySegment a, MemorySegment b, int length) {
            try {
                return sqr7u$mh.invokeExact(a, b, length);
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }

        @Override
        public MethodHandle dotProductHandle7u() {
            return DOT_HANDLE_7U;
        }

        @Override
        public MethodHandle squareDistanceHandle7u() {
            return SQR_HANDLE_7U;
        }

        static {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodType mt = MethodType.methodType(Integer.TYPE, MemorySegment.class, MemorySegment.class, Integer.TYPE);
                DOT_HANDLE_7U = lookup.findStatic(JdkVectorSimilarityFunctions.class, "dotProduct7u", mt);
                SQR_HANDLE_7U = lookup.findStatic(JdkVectorSimilarityFunctions.class, "squareDistance7u", mt);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

