/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;
import org.elasticsearch.nativeaccess.CloseableByteBuffer;
import org.elasticsearch.nativeaccess.NativeAccessHolder;
import org.elasticsearch.nativeaccess.ProcessLimits;
import org.elasticsearch.nativeaccess.Systemd;
import org.elasticsearch.nativeaccess.VectorSimilarityFunctions;
import org.elasticsearch.nativeaccess.WindowsFunctions;
import org.elasticsearch.nativeaccess.Zstd;

public interface NativeAccess {
    public static NativeAccess instance() {
        return NativeAccessHolder.INSTANCE;
    }

    public boolean definitelyRunningAsRoot();

    public ProcessLimits getProcessLimits();

    public void tryLockMemory();

    public boolean isMemoryLocked();

    public void tryInstallExecSandbox();

    public ExecSandboxState getExecSandboxState();

    public Systemd systemd();

    public Zstd getZstd();

    public OptionalLong allocatedSizeInBytes(Path var1);

    public void tryPreallocate(Path var1, long var2);

    default public WindowsFunctions getWindowsFunctions() {
        return null;
    }

    public Optional<VectorSimilarityFunctions> getVectorSimilarityFunctions();

    public CloseableByteBuffer newBuffer(int var1);

    public static enum ExecSandboxState {
        NONE,
        EXISTING_THREADS,
        ALL_THREADS;

    }
}

