/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.nio.ChannelContext;
import org.elasticsearch.nio.ChannelFactory;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioServerSocketChannel;
import org.elasticsearch.nio.NioSocketChannel;

public class ServerChannelContext
extends ChannelContext<ServerSocketChannel> {
    private final NioServerSocketChannel channel;
    private final NioSelector selector;
    private final Consumer<NioSocketChannel> acceptor;
    private final AtomicBoolean isClosing = new AtomicBoolean(false);
    private final ChannelFactory<?, ?> channelFactory;

    public ServerChannelContext(NioServerSocketChannel channel, ChannelFactory<?, ?> channelFactory, NioSelector selector, Consumer<NioSocketChannel> acceptor, Consumer<Exception> exceptionHandler) {
        super(channel.getRawChannel(), exceptionHandler);
        this.channel = channel;
        this.channelFactory = channelFactory;
        this.selector = selector;
        this.acceptor = acceptor;
    }

    public void acceptChannels(Supplier<NioSelector> selectorSupplier) throws IOException {
        Object acceptedChannel;
        while ((acceptedChannel = this.channelFactory.acceptNioChannel(this, selectorSupplier)) != null) {
            this.acceptor.accept((NioSocketChannel)acceptedChannel);
        }
    }

    @Override
    public void closeChannel() {
        if (this.isClosing.compareAndSet(false, true)) {
            this.getSelector().queueChannelClose(this.channel);
        }
    }

    @Override
    public NioSelector getSelector() {
        return this.selector;
    }

    @Override
    public NioServerSocketChannel getChannel() {
        return this.channel;
    }
}

