/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio.utils;

import java.util.List;

public class ExceptionsHelper {
    public static <T extends Throwable> void rethrowAndSuppress(List<T> exceptions) throws T {
        Throwable main = null;
        for (Throwable ex : exceptions) {
            main = ExceptionsHelper.useOrSuppress(main, ex);
        }
        if (main != null) {
            throw main;
        }
    }

    private static <T extends Throwable> T useOrSuppress(T first, T second) {
        if (first == null) {
            return second;
        }
        first.addSuppressed(second);
        return first;
    }
}

