/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.net.InetSocketAddress;

public abstract class Config {
    private final boolean tcpReuseAddress;

    public Config(boolean tcpReuseAddress) {
        this.tcpReuseAddress = tcpReuseAddress;
    }

    public boolean tcpReuseAddress() {
        return this.tcpReuseAddress;
    }

    public static class ServerSocket
    extends Config {
        private InetSocketAddress localAddress;

        public ServerSocket(boolean tcpReuseAddress, InetSocketAddress localAddress) {
            super(tcpReuseAddress);
            this.localAddress = localAddress;
        }

        public InetSocketAddress getLocalAddress() {
            return this.localAddress;
        }
    }

    public static class Socket
    extends Config {
        private final boolean tcpNoDelay;
        private final boolean tcpKeepAlive;
        private final int tcpKeepIdle;
        private final int tcpKeepInterval;
        private final int tcpKeepCount;
        private final int tcpSendBufferSize;
        private final int tcpReceiveBufferSize;
        private final InetSocketAddress remoteAddress;
        private final boolean isAccepted;

        public Socket(boolean tcpNoDelay, boolean tcpKeepAlive, int tcpKeepIdle, int tcpKeepInterval, int tcpKeepCount, boolean tcpReuseAddress, int tcpSendBufferSize, int tcpReceiveBufferSize, InetSocketAddress remoteAddress, boolean isAccepted) {
            super(tcpReuseAddress);
            this.tcpNoDelay = tcpNoDelay;
            this.tcpKeepAlive = tcpKeepAlive;
            this.tcpKeepIdle = tcpKeepIdle;
            this.tcpKeepInterval = tcpKeepInterval;
            this.tcpKeepCount = tcpKeepCount;
            this.tcpSendBufferSize = tcpSendBufferSize;
            this.tcpReceiveBufferSize = tcpReceiveBufferSize;
            this.remoteAddress = remoteAddress;
            this.isAccepted = isAccepted;
        }

        public boolean tcpNoDelay() {
            return this.tcpNoDelay;
        }

        public boolean tcpKeepAlive() {
            return this.tcpKeepAlive;
        }

        public int tcpKeepIdle() {
            return this.tcpKeepIdle;
        }

        public int tcpKeepInterval() {
            return this.tcpKeepInterval;
        }

        public int tcpKeepCount() {
            return this.tcpKeepCount;
        }

        public int tcpSendBufferSize() {
            return this.tcpSendBufferSize;
        }

        public int tcpReceiveBufferSize() {
            return this.tcpReceiveBufferSize;
        }

        public boolean isAccepted() {
            return this.isAccepted;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }
    }
}

