/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nio;

import java.io.Closeable;
import java.nio.ByteBuffer;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;

public class Page
implements Closeable {
    private final ByteBuffer byteBuffer;
    private final RefCountedCloseable refCountedCloseable;

    public Page(ByteBuffer byteBuffer) {
        this(byteBuffer, () -> {});
    }

    public Page(ByteBuffer byteBuffer, Runnable closeable) {
        this(byteBuffer, new RefCountedCloseable(closeable));
    }

    private Page(ByteBuffer byteBuffer, RefCountedCloseable refCountedCloseable) {
        this.byteBuffer = byteBuffer;
        this.refCountedCloseable = refCountedCloseable;
    }

    public Page duplicate() {
        this.refCountedCloseable.incRef();
        return new Page(this.byteBuffer.duplicate(), this.refCountedCloseable);
    }

    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public void close() {
        this.refCountedCloseable.decRef();
    }

    private static class RefCountedCloseable
    extends AbstractRefCounted {
        private final Runnable closeable;

        private RefCountedCloseable(Runnable closeable) {
            super("byte array page");
            this.closeable = closeable;
        }

        protected void closeInternal() {
            this.closeable.run();
        }
    }
}

