/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.preallocate;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.preallocate.LinuxPreallocator;
import org.elasticsearch.preallocate.MacOsPreallocator;
import org.elasticsearch.preallocate.NoNativePreallocator;
import org.elasticsearch.preallocate.Preallocator;

public class Preallocate {
    private static final Logger logger = LogManager.getLogger(Preallocate.class);
    private static final boolean IS_LINUX;
    private static final boolean IS_MACOS;

    public static void preallocate(Path cacheFile, long fileSize) throws IOException {
        if (IS_LINUX) {
            Preallocate.preallocate(cacheFile, fileSize, new LinuxPreallocator());
        } else if (IS_MACOS) {
            Preallocate.preallocate(cacheFile, fileSize, new MacOsPreallocator());
        } else {
            Preallocate.preallocate(cacheFile, fileSize, new NoNativePreallocator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="need access to fd on FileOutputStream")
    private static void preallocate(Path cacheFile, long fileSize, Preallocator prealloactor) throws IOException {
        boolean success = false;
        try {
            if (prealloactor.useNative()) {
                try (FileOutputStream fileChannel = new FileOutputStream(cacheFile.toFile());){
                    long currentSize = fileChannel.getChannel().size();
                    if (currentSize < fileSize) {
                        logger.info("pre-allocating cache file [{}] ({} bytes) using native methods", new Object[]{cacheFile, fileSize});
                        Field field = AccessController.doPrivileged(new FileDescriptorFieldAction(fileChannel));
                        int errno = prealloactor.preallocate((Integer)field.get(fileChannel.getFD()), currentSize, fileSize - currentSize);
                        if (errno == 0) {
                            success = true;
                            logger.debug("pre-allocated cache file [{}] using native methods", new Object[]{cacheFile});
                        } else {
                            logger.warn("failed to pre-allocate cache file [{}] using native methods, errno: [{}], error: [{}]", new Object[]{cacheFile, errno, prealloactor.error(errno)});
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn(() -> "failed to pre-allocate cache file [" + cacheFile + "] using native methods", (Throwable)e);
                }
            }
            try (RandomAccessFile raf = new RandomAccessFile(cacheFile.toFile(), "rw");){
                if (raf.length() != fileSize) {
                    logger.info("pre-allocating cache file [{}] ({} bytes) using setLength method", new Object[]{cacheFile, fileSize});
                    raf.setLength(fileSize);
                    logger.debug("pre-allocated cache file [{}] using setLength method", new Object[]{cacheFile});
                }
                success = raf.length() == fileSize;
            }
            catch (Exception e) {
                logger.warn(() -> "failed to pre-allocate cache file [" + cacheFile + "] using setLength method", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (!success) {
                Files.deleteIfExists(cacheFile);
            }
        }
    }

    static {
        String osName = System.getProperty("os.name");
        IS_LINUX = osName.startsWith("Linux");
        IS_MACOS = osName.startsWith("Mac OS X");
    }

    @SuppressForbidden(reason="need access to fd on FileOutputStream")
    private static class FileDescriptorFieldAction
    implements PrivilegedExceptionAction<Field> {
        private final FileOutputStream fileOutputStream;

        private FileDescriptorFieldAction(FileOutputStream fileOutputStream) {
            this.fileOutputStream = fileOutputStream;
        }

        @Override
        public Field run() throws IOException, NoSuchFieldException {
            Field f = this.fileOutputStream.getFD().getClass().getDeclaredField("fd");
            f.setAccessible(true);
            return f;
        }
    }
}

