/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.preallocate;

import com.sun.jna.FunctionMapper;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.io.IOException;
import java.security.AccessController;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.preallocate.Preallocator;

abstract class AbstractPosixPreallocator
implements Preallocator {
    private static final int O_WRONLY = 1;
    public static final boolean NATIVES_AVAILABLE;
    private static final NativeFunctions functions;
    private static final FStat64Function fstat64;
    protected final PosixConstants constants;

    AbstractPosixPreallocator(PosixConstants constants) {
        this.constants = constants;
    }

    @Override
    public boolean useNative() {
        return false;
    }

    @Override
    public Preallocator.NativeFileHandle open(String path) throws IOException {
        int fd = functions.open(path, 1, this.constants.O_CREAT);
        if (fd < 0) {
            throw AbstractPosixPreallocator.newIOException(String.format(Locale.ROOT, "Could not open file [%s] for preallocation", path));
        }
        return new PosixNativeFileHandle(fd);
    }

    @Override
    public String error(int errno) {
        return functions.strerror(errno);
    }

    private static IOException newIOException(String prefix) {
        int errno = Native.getLastError();
        return new IOException(String.format(Locale.ROOT, "%s(errno=%d): %s", prefix, errno, functions.strerror(errno)));
    }

    static {
        functions = AccessController.doPrivileged(() -> {
            try {
                return (NativeFunctions)Native.load((String)Platform.C_LIBRARY_NAME, NativeFunctions.class);
            }
            catch (UnsatisfiedLinkError e) {
                return null;
            }
        });
        fstat64 = AccessController.doPrivileged(() -> {
            try {
                return (FStat64Function)Native.load((String)Platform.C_LIBRARY_NAME, FStat64Function.class);
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    Map<String, FunctionMapper> options = Map.of("function-mapper", (lib, method) -> "__fxstat64");
                    return (FStat64Function)Native.load((String)Platform.C_LIBRARY_NAME, FStat64Function.class, options);
                }
                catch (UnsatisfiedLinkError e2) {
                    return null;
                }
            }
        });
        NATIVES_AVAILABLE = functions != null && fstat64 != null;
    }

    protected record PosixConstants(int SIZEOF_STAT, int STAT_ST_SIZE_OFFSET, int O_CREAT) {
    }

    private static interface NativeFunctions
    extends Library {
        public String strerror(int var1);

        public int open(String var1, int var2, Object ... var3);

        public int close(int var1);
    }

    private class PosixNativeFileHandle
    implements Preallocator.NativeFileHandle {
        private final int fd;

        PosixNativeFileHandle(int fd) {
            this.fd = fd;
        }

        @Override
        public int fd() {
            return this.fd;
        }

        @Override
        public long getSize() throws IOException {
            Stat64 stat = new Stat64(AbstractPosixPreallocator.this.constants.SIZEOF_STAT, AbstractPosixPreallocator.this.constants.STAT_ST_SIZE_OFFSET);
            if (fstat64.fstat64(this.fd, stat) == -1) {
                throw AbstractPosixPreallocator.newIOException("Could not get size of file");
            }
            return stat.st_size.longValue();
        }

        @Override
        public void close() throws IOException {
            if (functions.close(this.fd) != 0) {
                throw AbstractPosixPreallocator.newIOException("Could not close file");
            }
        }
    }

    private static interface FStat64Function
    extends Library {
        public int fstat64(int var1, Stat64 var2);
    }

    static final class Stat64
    extends Structure
    implements Structure.ByReference {
        public byte[] _ignore1;
        public NativeLong st_size = new NativeLong(0L);
        public byte[] _ignore2;

        Stat64(int sizeof, int stSizeOffset) {
            this._ignore1 = new byte[stSizeOffset];
            this._ignore2 = new byte[sizeof - stSizeOffset - 8];
        }
    }
}

