/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.preallocate;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import java.lang.invoke.MethodHandles;
import java.security.AccessController;
import org.elasticsearch.preallocate.AbstractPosixPreallocator;

final class MacOsPreallocator
extends AbstractPosixPreallocator {
    MacOsPreallocator() {
        super(new AbstractPosixPreallocator.PosixConstants(144, 96, 512));
    }

    @Override
    public boolean useNative() {
        return Natives.NATIVES_AVAILABLE && super.useNative();
    }

    @Override
    public int preallocate(int fd, long currentSize, long fileSize) {
        Natives.Fcntl.FStore fst = new Natives.Fcntl.FStore();
        fst.setFlags(2);
        fst.setPosmode(3);
        fst.setOffset(0L);
        fst.setLength(fileSize);
        logger.info("Calling fcntl for preallocate");
        if (Natives.functions.fcntl(fd, 42, fst.memory) != 0) {
            logger.warn("Failed to get contiguous preallocate, trying non-contiguous");
            fst.setFlags(4);
            if (Natives.functions.fcntl(fd, 42, fst.memory) != 0) {
                logger.warn("Failed to get non-continugous preallocate");
                return Native.getLastError();
            }
        }
        if (Natives.functions.ftruncate(fd, new NativeLong(fileSize)) != 0) {
            logger.warn("Failed to ftruncate");
            return Native.getLastError();
        }
        return 0;
    }

    static {
        try {
            MethodHandles.lookup().ensureInitialized(Natives.class);
            logger.info("Initialized macos natives: " + Natives.NATIVES_AVAILABLE);
        }
        catch (IllegalAccessException unexpected) {
            throw new AssertionError((Object)unexpected);
        }
    }

    private static class Natives {
        static final boolean NATIVES_AVAILABLE;
        static final NativeFunctions functions;

        private Natives() {
        }

        static {
            NativeFunctions nativeFunctions;
            functions = nativeFunctions = AccessController.doPrivileged(() -> {
                try {
                    return (NativeFunctions)Native.load((String)Platform.C_LIBRARY_NAME, NativeFunctions.class);
                }
                catch (UnsatisfiedLinkError e) {
                    AbstractPosixPreallocator.logger.warn("Failed to load macos native preallocate functions");
                    return null;
                }
            });
            NATIVES_AVAILABLE = nativeFunctions != null;
        }

        private static interface NativeFunctions
        extends Library {
            public int fcntl(int var1, int var2, Object ... var3);

            public int ftruncate(int var1, NativeLong var2);
        }

        static class Fcntl {
            private static final int F_PREALLOCATE = 42;
            private static final int F_ALLOCATECONTIG = 2;
            private static final int F_ALLOCATEALL = 4;
            private static final int F_PEOFPOSMODE = 3;
            private static final int F_VOLPOSMODE = 4;

            Fcntl() {
            }

            public static final class FStore {
                final Memory memory = new Memory(32L);

                public void setFlags(int flags) {
                    this.memory.setInt(0L, flags);
                }

                public void setPosmode(int posmode) {
                    this.memory.setInt(4L, posmode);
                }

                public void setOffset(long offset) {
                    this.memory.setLong(8L, offset);
                }

                public void setLength(long length) {
                    this.memory.setLong(16L, length);
                }

                public void getBytesalloc() {
                    this.memory.getLong(24L);
                }
            }
        }
    }
}

