/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.simdvec.internal.vectorization;

import org.apache.lucene.util.BitUtil;

final class ByteArrayUtils {
    ByteArrayUtils() {
    }

    static int indexOf(byte[] bytes, int offset, int len, byte marker) {
        int end = offset + len;
        int i = offset;
        int byteCount = len & 7;
        if (byteCount > 0) {
            int index = ByteArrayUtils.unrolledFirstIndexOf(bytes, i, byteCount, marker);
            if (index != -1) {
                return index - offset;
            }
            if ((i += byteCount) == end) {
                return -1;
            }
        }
        int longCount = len >>> 3;
        long pattern = ByteArrayUtils.compilePattern(marker);
        for (int j = 0; j < longCount; ++j) {
            int index = ByteArrayUtils.findInLong(ByteArrayUtils.readLongLE(bytes, i), pattern);
            if (index < 8) {
                return i + index - offset;
            }
            i += 8;
        }
        return -1;
    }

    private static long readLongLE(byte[] arr, int offset) {
        return BitUtil.VH_LE_LONG.get(arr, offset);
    }

    private static long compilePattern(byte byteToFind) {
        return ((long)byteToFind & 0xFFL) * 0x101010101010101L;
    }

    private static int findInLong(long word, long pattern) {
        long input = word ^ pattern;
        long tmp = (input & 0x7F7F7F7F7F7F7F7FL) + 0x7F7F7F7F7F7F7F7FL;
        tmp = (tmp | input | 0x7F7F7F7F7F7F7F7FL) ^ 0xFFFFFFFFFFFFFFFFL;
        int binaryPosition = Long.numberOfTrailingZeros(tmp);
        return binaryPosition >>> 3;
    }

    private static int unrolledFirstIndexOf(byte[] buffer, int fromIndex, int byteCount, byte value) {
        if (buffer[fromIndex] == value) {
            return fromIndex;
        }
        if (byteCount == 1) {
            return -1;
        }
        if (buffer[fromIndex + 1] == value) {
            return fromIndex + 1;
        }
        if (byteCount == 2) {
            return -1;
        }
        if (buffer[fromIndex + 2] == value) {
            return fromIndex + 2;
        }
        if (byteCount == 3) {
            return -1;
        }
        if (buffer[fromIndex + 3] == value) {
            return fromIndex + 3;
        }
        if (byteCount == 4) {
            return -1;
        }
        if (buffer[fromIndex + 4] == value) {
            return fromIndex + 4;
        }
        if (byteCount == 5) {
            return -1;
        }
        if (buffer[fromIndex + 5] == value) {
            return fromIndex + 5;
        }
        if (byteCount == 6) {
            return -1;
        }
        if (buffer[fromIndex + 6] == value) {
            return fromIndex + 6;
        }
        return -1;
    }
}

