/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.util.regex.Regex;

public abstract class FieldFilter {
    public static final Result INCLUDED = new Result(true);
    public static final Result EXCLUDED = new Result(false);

    public static Result filter(String path, Collection<NumberedInclude> includes, Collection<String> excludes, boolean allowPartialMatches) {
        includes = includes == null ? Collections.emptyList() : includes;
        Collection<Object> collection = excludes = excludes == null ? Collections.emptyList() : excludes;
        if (includes.isEmpty() && excludes.isEmpty()) {
            return INCLUDED;
        }
        if (Regex.simpleMatch(excludes, path)) {
            return EXCLUDED;
        }
        boolean exactIncludeMatch = false;
        boolean pathIsPrefixOfAnInclude = false;
        NumberedInclude matchedInclude = null;
        if (includes.isEmpty()) {
            exactIncludeMatch = true;
        } else {
            Iterator<NumberedInclude> iterator = includes.iterator();
            while (iterator.hasNext()) {
                NumberedInclude filter;
                matchedInclude = filter = iterator.next();
                String include = filter.filter;
                if (include.charAt(0) == '*' && Regex.simpleMatch(include, path)) {
                    exactIncludeMatch = true;
                    break;
                }
                if (include.startsWith(path)) {
                    if (include.length() == path.length()) {
                        exactIncludeMatch = true;
                        break;
                    }
                    if (include.length() > path.length() && include.charAt(path.length()) == '.') {
                        pathIsPrefixOfAnInclude = true;
                        continue;
                    }
                }
                if (!Regex.simpleMatch(include, path)) continue;
                exactIncludeMatch = true;
                break;
            }
        }
        if (exactIncludeMatch || allowPartialMatches && pathIsPrefixOfAnInclude) {
            return matchedInclude != null ? new Result(true, matchedInclude.depth) : INCLUDED;
        }
        return EXCLUDED;
    }

    public static Result filter(String path, Collection<NumberedInclude> includes, Collection<String> excludes) {
        return FieldFilter.filter(path, includes, excludes, true);
    }

    public static List<NumberedInclude> toNumberedFilter(Collection<String> includeAsStrings) {
        if (includeAsStrings == null || includeAsStrings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NumberedInclude> numberedIncludes = new ArrayList<NumberedInclude>(includeAsStrings.size());
        for (String include : includeAsStrings) {
            int index = include.indexOf(":");
            String filter = include;
            int depth = 1;
            try {
                if (index > 0) {
                    filter = include.substring(0, index);
                    String depthString = include.substring(index + 1);
                    if (depthString.length() > 0) {
                        depth = Integer.parseInt(depthString);
                    }
                }
            }
            catch (NumberFormatException ex) {
                throw new EsHadoopIllegalArgumentException(String.format(Locale.ROOT, "Invalid parameter [%s] specified in inclusion configuration", include), ex);
            }
            numberedIncludes.add(new NumberedInclude(filter, depth));
        }
        return numberedIncludes;
    }

    public static class NumberedInclude {
        public final String filter;
        public final int depth;

        public NumberedInclude(String filter) {
            this(filter, 1);
        }

        public NumberedInclude(String filter, int depth) {
            this.filter = filter;
            this.depth = depth;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NumberedInclude that = (NumberedInclude)o;
            if (this.depth != that.depth) {
                return false;
            }
            return this.filter != null ? this.filter.equals(that.filter) : that.filter == null;
        }

        public int hashCode() {
            int result = this.filter != null ? this.filter.hashCode() : 0;
            result = 31 * result + this.depth;
            return result;
        }

        public String toString() {
            return "NumberedInclude{" + this.filter + ":" + this.depth + "}";
        }
    }

    public static class Result {
        public final boolean matched;
        public final int depth;

        public Result(boolean matched) {
            this(matched, 1);
        }

        public Result(boolean matched, int depth) {
            this.matched = matched;
            this.depth = depth;
        }
    }
}

