/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import java.util.EnumMap;
import org.elasticsearch.hadoop.EsHadoopUnsupportedOperationException;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.EsMajorVersion;

public abstract class PerEntityPoolingMetadataExtractor
implements MetadataExtractor {
    protected EsMajorVersion version;
    protected Object entity;
    private final EnumMap<MetadataExtractor.Metadata, StaticFieldExtractor> pool = new EnumMap(MetadataExtractor.Metadata.class);

    public PerEntityPoolingMetadataExtractor(EsMajorVersion version) {
        this.version = version;
    }

    public void reset() {
        this.entity = null;
    }

    @Override
    public FieldExtractor get(MetadataExtractor.Metadata metadata) {
        StaticFieldExtractor fieldExtractor = this.pool.get((Object)metadata);
        if (fieldExtractor == null || fieldExtractor.needsInit()) {
            Object value = this.getValue(metadata);
            if (value == null) {
                return null;
            }
            if (fieldExtractor == null) {
                fieldExtractor = this.createExtractorFor(metadata);
            }
            if (fieldExtractor.needsInit()) {
                fieldExtractor.setField(value);
            }
            this.pool.put(metadata, fieldExtractor);
        }
        return fieldExtractor;
    }

    private StaticFieldExtractor createExtractorFor(MetadataExtractor.Metadata metadata) {
        if (this.version.onOrAfter(EsMajorVersion.V_6_X)) {
            switch (metadata) {
                case TTL: 
                case TIMESTAMP: {
                    return new UnsupportedMetadataFieldExtractor(metadata, this.version);
                }
            }
        }
        return new StaticFieldExtractor();
    }

    public abstract Object getValue(MetadataExtractor.Metadata var1);

    public void setObject(Object entity) {
        this.entity = entity;
    }

    private static class UnsupportedMetadataFieldExtractor
    extends StaticFieldExtractor {
        private MetadataExtractor.Metadata unsupportedMetadata;
        private EsMajorVersion version;

        public UnsupportedMetadataFieldExtractor(MetadataExtractor.Metadata unsupportedMetadata, EsMajorVersion version) {
            this.unsupportedMetadata = unsupportedMetadata;
            this.version = version;
        }

        @Override
        public Object field(Object target) {
            throw new EsHadoopUnsupportedOperationException("Unsupported metadata tag [" + this.unsupportedMetadata.getName() + "] for Elasticsearch version [" + this.version.toString() + "]. Bailing out...");
        }
    }

    private static class StaticFieldExtractor
    implements FieldExtractor {
        private Object field;
        private boolean needsInit = true;

        private StaticFieldExtractor() {
        }

        @Override
        public Object field(Object target) {
            return this.field;
        }

        public void setField(Object field) {
            this.field = field;
            this.needsInit = true;
        }

        public boolean needsInit() {
            return this.needsInit;
        }
    }
}

