/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class NetworkUtils {
    private NetworkUtils() {
    }

    private static void addAllInterfaces(List<NetworkInterface> target, List<NetworkInterface> level) {
        if (!level.isEmpty()) {
            target.addAll(level);
            for (NetworkInterface intf : level) {
                NetworkUtils.addAllInterfaces(target, Collections.list(intf.getSubInterfaces()));
            }
        }
    }

    static List<NetworkInterface> getInterfaces() throws SocketException {
        ArrayList<NetworkInterface> all = new ArrayList<NetworkInterface>();
        NetworkUtils.addAllInterfaces(all, Collections.list(NetworkInterface.getNetworkInterfaces()));
        return all;
    }

    static InetAddress[] getGlobalInterfaces() throws SocketException {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        for (NetworkInterface intf : NetworkUtils.getInterfaces()) {
            if (!intf.isUp()) continue;
            for (InetAddress address : Collections.list(intf.getInetAddresses())) {
                if (address.isLoopbackAddress() || address.isSiteLocalAddress() || address.isLinkLocalAddress()) continue;
                list.add(address);
            }
        }
        return list.toArray(new InetAddress[list.size()]);
    }
}

