/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.dto.mapping.Mapping;

public class MappingSet
implements Serializable {
    private static final String RESOLVED_INDEX_NAME = "*";
    private static final String RESOLVED_MAPPING_NAME = "*";
    public static final String TYPELESS_MAPPING_NAME = "";
    private final boolean empty;
    private final Map<String, Map<String, Mapping>> indexTypeMap = new HashMap<String, Map<String, Mapping>>();
    private final Mapping resolvedSchema;

    public MappingSet(List<Mapping> mappings) {
        if (mappings.isEmpty()) {
            this.empty = true;
            this.resolvedSchema = new Mapping("*", "*", Field.NO_FIELDS);
        } else {
            this.empty = false;
            for (Mapping mapping : mappings) {
                String indexName = mapping.getIndex();
                String typeName = mapping.getType();
                Map<String, Mapping> mappingsToSchema = this.indexTypeMap.get(indexName);
                if (mappingsToSchema == null) {
                    mappingsToSchema = new HashMap<String, Mapping>();
                    this.indexTypeMap.put(indexName, mappingsToSchema);
                }
                if (mappingsToSchema.containsKey(typeName)) {
                    String message = typeName.equals(TYPELESS_MAPPING_NAME) ? String.format("Invalid mapping set given. Multiple unnamed mappings in the index [%s].", indexName) : String.format("Invalid mapping set given. Multiple mappings of the same name [%s] in the index [%s].", typeName, indexName);
                    throw new EsHadoopIllegalArgumentException(message);
                }
                mappingsToSchema.put(typeName, mapping);
            }
            this.resolvedSchema = MappingSet.mergeMappings(mappings);
        }
    }

    private static Mapping mergeMappings(List<Mapping> mappings) {
        LinkedHashMap<String, Object[]> fieldMap = new LinkedHashMap<String, Object[]>();
        for (Mapping mapping : mappings) {
            for (Field field : mapping.getFields()) {
                MappingSet.addToFieldTable(field, TYPELESS_MAPPING_NAME, fieldMap);
            }
        }
        Field[] collapsed = MappingSet.collapseFields(fieldMap);
        return new Mapping("*", "*", collapsed);
    }

    private static void addToFieldTable(Field field, String parent, Map<String, Object[]> fieldTable) {
        String fullName = parent + field.name();
        Object[] entry = fieldTable.get(fullName);
        if (entry == null) {
            if (FieldType.isCompound(field.type())) {
                LinkedHashMap<String, Object[]> subTable = new LinkedHashMap<String, Object[]>();
                entry = new Object[]{field, subTable};
                String prefix = fullName + ".";
                for (Field subField : field.properties()) {
                    MappingSet.addToFieldTable(subField, prefix, subTable);
                }
            } else {
                entry = new Object[]{field};
            }
            fieldTable.put(fullName, entry);
        } else {
            Field previousField = (Field)entry[0];
            if (!previousField.type().equals((Object)field.type())) {
                FieldType resolvedType = MappingSet.resolveTypeConflict(fullName, previousField.type(), field.type());
                if (!previousField.type().equals((Object)resolvedType)) {
                    previousField = new Field(previousField.name(), resolvedType, previousField.properties());
                    entry[0] = previousField;
                }
            }
            if (FieldType.isCompound(field.type())) {
                Map subTable = (Map)entry[1];
                String prefix = fullName + ".";
                for (Field subField : field.properties()) {
                    MappingSet.addToFieldTable(subField, prefix, subTable);
                }
            }
        }
    }

    private static FieldType resolveTypeConflict(String fullName, FieldType existing, FieldType incoming) {
        LinkedHashSet<FieldType> incomingSuperTypes = incoming.getCastingTypes();
        if (incomingSuperTypes.contains((Object)existing)) {
            return existing;
        }
        LinkedHashSet<FieldType> existingSuperTypes = existing.getCastingTypes();
        if (existingSuperTypes.contains((Object)incoming)) {
            return incoming;
        }
        if (incomingSuperTypes.size() > 0 && existingSuperTypes.size() > 0) {
            LinkedHashSet<FieldType> combined = new LinkedHashSet<FieldType>(incomingSuperTypes);
            combined.retainAll(existingSuperTypes);
            if (combined.size() > 0) {
                return (FieldType)((Object)combined.iterator().next());
            }
        }
        throw new EsHadoopIllegalArgumentException("Incompatible types found in multi-mapping: Field [" + fullName + "] has conflicting types of [" + (Object)((Object)existing) + "] and [" + (Object)((Object)incoming) + "].");
    }

    private static Field[] collapseFields(Map<String, Object[]> fieldTable) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Map.Entry<String, Object[]> fieldInfo : fieldTable.entrySet()) {
            Field currentField = (Field)fieldInfo.getValue()[0];
            if (FieldType.isCompound(currentField.type())) {
                Map subTable = (Map)fieldInfo.getValue()[1];
                Field[] children = MappingSet.collapseFields(subTable);
                fields.add(new Field(currentField.name(), currentField.type(), children));
                continue;
            }
            fields.add(currentField);
        }
        return fields.size() == 0 ? Field.NO_FIELDS : fields.toArray(new Field[fields.size()]);
    }

    public Mapping getMapping(String index, String type) {
        Mapping mapping = null;
        Map<String, Mapping> mappings = this.indexTypeMap.get(index);
        if (mappings != null) {
            mapping = mappings.get(type);
        }
        return mapping;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public Mapping getResolvedView() {
        return this.resolvedSchema;
    }

    public String toString() {
        return "MappingSet{indexTypeMap=" + this.indexTypeMap + ", resolvedSchema=" + this.resolvedSchema + '}';
    }
}

