/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.hadoop.util.ArrayUtils;
import org.elasticsearch.hadoop.util.ByteSequence;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.UnicodeUtil;

public class BytesArray
implements ByteSequence {
    public static final byte[] EMPTY = new byte[0];
    byte[] bytes = EMPTY;
    int offset = 0;
    int size = 0;

    public BytesArray(int size) {
        this(new byte[size], 0, 0);
    }

    public BytesArray(byte[] data) {
        this(data, 0, data.length);
    }

    public BytesArray(byte[] data, int size) {
        this(data, 0, size);
    }

    public BytesArray(byte[] data, int offset, int size) {
        this.bytes = data;
        this.offset = offset;
        this.size = size;
    }

    public BytesArray(String source) {
        this.bytes(source);
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int offset() {
        return this.offset;
    }

    @Override
    public int length() {
        return this.size;
    }

    public int capacity() {
        return this.bytes.length;
    }

    public int available() {
        return this.bytes.length - this.size;
    }

    public void bytes(byte[] array) {
        this.bytes = array;
        this.size = array.length;
        this.offset = 0;
    }

    public void bytes(byte[] array, int size) {
        this.bytes = array;
        this.size = size;
        this.offset = 0;
    }

    public void bytes(BytesArray ba) {
        this.bytes = ba.bytes;
        this.size = ba.size;
        this.offset = ba.offset;
    }

    public void bytes(String from) {
        this.size = 0;
        this.offset = 0;
        UnicodeUtil.UTF16toUTF8(from, 0, from.length(), this);
    }

    public void size(int size) {
        this.size = size;
    }

    public void offset(int offset) {
        this.offset = offset;
    }

    public String toString() {
        return StringUtils.asUTFString(this.bytes, this.offset, this.size);
    }

    public void reset() {
        this.offset = 0;
        this.size = 0;
    }

    public void copyTo(BytesArray to) {
        to.add(this.bytes, this.offset, this.size);
    }

    public void add(int b) {
        int newcount = this.size + 1;
        this.checkSize(newcount);
        this.bytes[this.size] = (byte)b;
        this.size = newcount;
    }

    public void add(byte[] b) {
        if (b == null || b.length == 0) {
            return;
        }
        this.add(b, 0, b.length);
    }

    public void add(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        int newcount = this.size + len;
        this.checkSize(newcount);
        try {
            System.arraycopy(b, off, this.bytes, this.size, len);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            System.err.println(String.format("Copying array of size %d, content %s, off %d, len %d to bytes with len %d at offset %d", b.length, new BytesArray(b), off, len, this.bytes.length, this.size));
            throw ex;
        }
        this.size = newcount;
    }

    public void add(String string) {
        if (string == null) {
            return;
        }
        this.add(string.getBytes(StringUtils.UTF_8));
    }

    private void checkSize(int newcount) {
        if (newcount > this.bytes.length) {
            this.bytes = ArrayUtils.grow(this.bytes, newcount);
        }
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.bytes, this.offset, this.size);
        out.flush();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytesArray that = (BytesArray)o;
        if (this.size != that.size) {
            return false;
        }
        if (this.bytes == that.bytes) {
            return true;
        }
        if (this.bytes == null || that.bytes == null) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.bytes[this.offset + i] == that.bytes[that.offset + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.bytes == null) {
            return 0;
        }
        int result = 1;
        for (int idx = this.offset; idx < this.size; ++idx) {
            result = 31 * result + this.bytes[idx];
        }
        result = 31 * result + this.offset;
        result = 31 * result + this.size;
        return result;
    }
}

