/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql.streaming;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.internal.SQLConf$;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.unit.TimeValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class SparkSqlStreamingConfigs$ {
    public static SparkSqlStreamingConfigs$ MODULE$;
    private final String ES_SINK_LOG_ENABLE;
    private final boolean ES_SINK_LOG_ENABLE_DEFAULT;
    private final String ES_SINK_LOG_PATH;
    private final String ES_INTERNAL_APP_NAME;
    private final String ES_INTERNAL_APP_ID;
    private final String ES_INTERNAL_QUERY_NAME;
    private final String ES_INTERNAL_USER_CHECKPOINT_LOCATION;
    private final String ES_INTERNAL_SESSION_CHECKPOINT_LOCATION;
    private final String ES_SINK_LOG_CLEANUP_DELAY;
    private final long ES_SINK_LOG_CLEANUP_DELAY_DEFAULT;
    private final String ES_SINK_LOG_DELETION;
    private final boolean ES_SINK_LOG_DELETION_DEFAULT;
    private final String ES_SINK_LOG_COMPACT_INTERVAL;
    private final int ES_SINK_LOG_COMPACT_INTERVAL_DEFAULT;

    static {
        new SparkSqlStreamingConfigs$();
    }

    public String ES_SINK_LOG_ENABLE() {
        return this.ES_SINK_LOG_ENABLE;
    }

    public boolean ES_SINK_LOG_ENABLE_DEFAULT() {
        return this.ES_SINK_LOG_ENABLE_DEFAULT;
    }

    public String ES_SINK_LOG_PATH() {
        return this.ES_SINK_LOG_PATH;
    }

    public String ES_INTERNAL_APP_NAME() {
        return this.ES_INTERNAL_APP_NAME;
    }

    public String ES_INTERNAL_APP_ID() {
        return this.ES_INTERNAL_APP_ID;
    }

    public String ES_INTERNAL_QUERY_NAME() {
        return this.ES_INTERNAL_QUERY_NAME;
    }

    public String ES_INTERNAL_USER_CHECKPOINT_LOCATION() {
        return this.ES_INTERNAL_USER_CHECKPOINT_LOCATION;
    }

    public String ES_INTERNAL_SESSION_CHECKPOINT_LOCATION() {
        return this.ES_INTERNAL_SESSION_CHECKPOINT_LOCATION;
    }

    public String ES_SINK_LOG_CLEANUP_DELAY() {
        return this.ES_SINK_LOG_CLEANUP_DELAY;
    }

    public long ES_SINK_LOG_CLEANUP_DELAY_DEFAULT() {
        return this.ES_SINK_LOG_CLEANUP_DELAY_DEFAULT;
    }

    public String ES_SINK_LOG_DELETION() {
        return this.ES_SINK_LOG_DELETION;
    }

    public boolean ES_SINK_LOG_DELETION_DEFAULT() {
        return this.ES_SINK_LOG_DELETION_DEFAULT;
    }

    public String ES_SINK_LOG_COMPACT_INTERVAL() {
        return this.ES_SINK_LOG_COMPACT_INTERVAL;
    }

    public int ES_SINK_LOG_COMPACT_INTERVAL_DEFAULT() {
        return this.ES_SINK_LOG_COMPACT_INTERVAL_DEFAULT;
    }

    public boolean getSinkLogEnabled(Settings settings) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)settings.getProperty(this.ES_SINK_LOG_ENABLE())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkSqlStreamingConfigs$.$anonfun$getSinkLogEnabled$1(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.ES_SINK_LOG_ENABLE_DEFAULT()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String constructCommitLogPath(Settings settings) {
        Option option;
        Option<String> queryName;
        Option<String> sessionCheckpointLocation;
        Option<String> userCheckpointLocation;
        Option<String> logPath = this.getLogPath(settings);
        Tuple4 tuple4 = new Tuple4(logPath, userCheckpointLocation = this.getUserSpecifiedCheckpointLocation(settings), sessionCheckpointLocation = this.getSessionCheckpointLocation(settings), queryName = this.getQueryName(settings));
        if (tuple4 != null && (option = (Option)tuple4._1()) instanceof Some) {
            Some some = (Some)option;
            String explicitPath = (String)some.value();
            return explicitPath;
        }
        if (tuple4 != null) {
            Option option2 = (Option)tuple4._1();
            Option option3 = (Option)tuple4._2();
            if (None$.MODULE$.equals(option2) && option3 instanceof Some) {
                Some some = (Some)option3;
                String userCheckpoint = (String)some.value();
                return new StringBuilder(20).append(userCheckpoint).append("/sinks/elasticsearch").toString();
            }
        }
        if (tuple4 != null) {
            Option option4 = (Option)tuple4._1();
            Option option5 = (Option)tuple4._2();
            Option option6 = (Option)tuple4._3();
            Option option7 = (Option)tuple4._4();
            if (None$.MODULE$.equals(option4) && None$.MODULE$.equals(option5) && option6 instanceof Some) {
                Some some = (Some)option6;
                String sessionCheckpoint = (String)some.value();
                if (None$.MODULE$.equals(option7)) {
                    return new StringBuilder(21).append(sessionCheckpoint).append("/").append(UUID.randomUUID().toString()).append("/sinks/elasticsearch").toString();
                }
            }
        }
        if (tuple4 != null) {
            Option option8 = (Option)tuple4._1();
            Option option9 = (Option)tuple4._2();
            Option option10 = (Option)tuple4._3();
            Option option11 = (Option)tuple4._4();
            if (None$.MODULE$.equals(option8) && None$.MODULE$.equals(option9) && option10 instanceof Some) {
                Some some = (Some)option10;
                String sessionCheckpoint = (String)some.value();
                if (option11 instanceof Some) {
                    Some some2 = (Some)option11;
                    String query = (String)some2.value();
                    return new StringBuilder(21).append(sessionCheckpoint).append("/").append(query).append("/sinks/elasticsearch").toString();
                }
            }
        }
        if (tuple4 == null) throw new MatchError((Object)tuple4);
        Option option12 = (Option)tuple4._1();
        Option option13 = (Option)tuple4._2();
        Option option14 = (Option)tuple4._3();
        if (!None$.MODULE$.equals(option12)) throw new MatchError((Object)tuple4);
        if (!None$.MODULE$.equals(option13)) throw new MatchError((Object)tuple4);
        if (!None$.MODULE$.equals(option14)) throw new MatchError((Object)tuple4);
        throw new EsHadoopIllegalArgumentException(new StringBuilder(314).append("Could not determine path for the Elasticsearch commit log. Specify the commit log location by setting the [checkpointLocation] option on your DataStreamWriter. If you do not want to persist the Elasticsearch commit log in the regular checkpoint location for your streaming query then you can specify a location to ").append(new StringBuilder(72).append("store the log with [").append(this.ES_SINK_LOG_PATH()).append("], or disable the commit log by setting [").append(this.ES_SINK_LOG_ENABLE()).append("] to false.").toString()).toString());
    }

    public Option<String> getLogPath(Settings settings) {
        return Option$.MODULE$.apply((Object)settings.getProperty(this.ES_SINK_LOG_PATH()));
    }

    public Option<String> getAppName(Settings settings) {
        return Option$.MODULE$.apply((Object)settings.getProperty(this.ES_INTERNAL_APP_NAME()));
    }

    public Option<String> getAppId(Settings settings) {
        return Option$.MODULE$.apply((Object)settings.getProperty(this.ES_INTERNAL_APP_ID()));
    }

    public Option<String> getQueryName(Settings settings) {
        return Option$.MODULE$.apply((Object)settings.getProperty(this.ES_INTERNAL_QUERY_NAME()));
    }

    public Option<String> getUserSpecifiedCheckpointLocation(Settings settings) {
        return Option$.MODULE$.apply((Object)settings.getProperty(this.ES_INTERNAL_USER_CHECKPOINT_LOCATION()));
    }

    public Option<String> getSessionCheckpointLocation(Settings settings) {
        return Option$.MODULE$.apply((Object)settings.getProperty(this.ES_INTERNAL_SESSION_CHECKPOINT_LOCATION()));
    }

    public long getFileCleanupDelayMs(Settings settings) {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)settings.getProperty(this.ES_SINK_LOG_CLEANUP_DELAY())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)SparkSqlStreamingConfigs$.$anonfun$getFileCleanupDelayMs$1(x$2))).orElse((Function0 & Serializable & scala.Serializable)() -> SQLConf$.MODULE$.FILE_SINK_LOG_CLEANUP_DELAY().defaultValue()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> MODULE$.ES_SINK_LOG_CLEANUP_DELAY_DEFAULT()));
    }

    public boolean getIsDeletingExpiredLog(Settings settings) {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)settings.getProperty(this.ES_SINK_LOG_DELETION())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkSqlStreamingConfigs$.$anonfun$getIsDeletingExpiredLog$1(x$3))).orElse((Function0 & Serializable & scala.Serializable)() -> SQLConf$.MODULE$.FILE_SINK_LOG_DELETION().defaultValue()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.ES_SINK_LOG_DELETION_DEFAULT()));
    }

    public int getDefaultCompactInterval(Settings settings) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)settings.getProperty(this.ES_SINK_LOG_COMPACT_INTERVAL())).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)SparkSqlStreamingConfigs$.$anonfun$getDefaultCompactInterval$1(x$4))).orElse((Function0 & Serializable & scala.Serializable)() -> SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().defaultValue()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.ES_SINK_LOG_COMPACT_INTERVAL_DEFAULT()));
    }

    public static final /* synthetic */ boolean $anonfun$getSinkLogEnabled$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public static final /* synthetic */ long $anonfun$getFileCleanupDelayMs$1(String x$2) {
        return TimeValue.parseTimeValue(x$2).getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$getIsDeletingExpiredLog$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toBoolean();
    }

    public static final /* synthetic */ int $anonfun$getDefaultCompactInterval$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    private SparkSqlStreamingConfigs$() {
        MODULE$ = this;
        this.ES_SINK_LOG_ENABLE = "es.spark.sql.streaming.sink.log.enabled";
        this.ES_SINK_LOG_ENABLE_DEFAULT = true;
        this.ES_SINK_LOG_PATH = "es.spark.sql.streaming.sink.log.path";
        this.ES_INTERNAL_APP_NAME = "es.internal.spark.sql.streaming.appName";
        this.ES_INTERNAL_APP_ID = "es.internal.spark.sql.streaming.appID";
        this.ES_INTERNAL_QUERY_NAME = "es.internal.spark.sql.streaming.queryName";
        this.ES_INTERNAL_USER_CHECKPOINT_LOCATION = "es.internal.spark.sql.streaming.userCheckpointLocation";
        this.ES_INTERNAL_SESSION_CHECKPOINT_LOCATION = "es.internal.spark.sql.streaming.sessionCheckpointLocation";
        this.ES_SINK_LOG_CLEANUP_DELAY = "es.spark.sql.streaming.sink.log.cleanupDelay";
        this.ES_SINK_LOG_CLEANUP_DELAY_DEFAULT = TimeUnit.MINUTES.toMillis(10L);
        this.ES_SINK_LOG_DELETION = "es.spark.sql.streaming.sink.log.deletion";
        this.ES_SINK_LOG_DELETION_DEFAULT = true;
        this.ES_SINK_LOG_COMPACT_INTERVAL = "es.spark.sql.streaming.sink.log.compactInterval";
        this.ES_SINK_LOG_COMPACT_INTERVAL_DEFAULT = 10;
    }
}

