/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.serialization;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.spark.serialization.ReflectionUtils$ReflectionLock$;
import org.elasticsearch.spark.serialization.ScalaValueWriter;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.ImplicitTags;
import scala.reflect.api.Symbols;
import scala.reflect.api.Types;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class ReflectionUtils$ {
    public static final ReflectionUtils$ MODULE$ = new ReflectionUtils$();
    private static final HashMap<Class<?>, Tuple2<Object, Iterable<String>>> caseClassCache = new HashMap();
    private static final HashMap<Class<?>, Tuple2<String, Method>[]> javaBeanCache = new HashMap();

    public HashMap<Class<?>, Tuple2<Object, Iterable<String>>> caseClassCache() {
        return caseClassCache;
    }

    public HashMap<Class<?>, Tuple2<String, Method>[]> javaBeanCache() {
        return javaBeanCache;
    }

    private boolean checkCaseClass(Class<?> clazz) {
        boolean bl;
        ReflectionUtils$ReflectionLock$ reflectionUtils$ReflectionLock$ = ReflectionUtils$ReflectionLock$.MODULE$;
        synchronized (reflectionUtils$ReflectionLock$) {
            bl = package$.MODULE$.universe().runtimeMirror(clazz.getClassLoader()).classSymbol(clazz).isCaseClass();
        }
        return bl;
    }

    private Iterable<String> doGetCaseClassInfo(Class<?> clazz) {
        Iterable iterable;
        ReflectionUtils$ReflectionLock$ reflectionUtils$ReflectionLock$ = ReflectionUtils$ReflectionLock$.MODULE$;
        synchronized (reflectionUtils$ReflectionLock$) {
            Types.TypeApi t = package$.MODULE$.universe().runtimeMirror(clazz.getClassLoader()).classSymbol(clazz).toType();
            Method decls = ReflectionUtils$.liftedTree1$1(t);
            Iterable scopes = (Iterable)decls.invoke((Object)t, new Object[0]);
            iterable = (Iterable)scopes.collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Symbols.SymbolApi, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Option option;
                    A1 A1 = x1;
                    Object object = A1 != null && !(option = ((ImplicitTags)package$.MODULE$.universe()).MethodSymbolTag().unapply(A1)).isEmpty() && option.get() != null && ((Symbols.TermSymbolApi)A1).isCaseAccessor() ? A1.name().toString() : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Symbols.SymbolApi x1) {
                    Option option;
                    Symbols.SymbolApi symbolApi = x1;
                    boolean bl = symbolApi != null && !(option = ((ImplicitTags)package$.MODULE$.universe()).MethodSymbolTag().unapply((Object)symbolApi)).isEmpty() && option.get() != null && ((Symbols.TermSymbolApi)symbolApi).isCaseAccessor();
                    return bl;
                }
            });
        }
        return iterable;
    }

    private boolean isCaseClassInsideACompanionModule(Class<?> clazz, int arity) {
        Object object = !Serializable.class.isAssignableFrom(clazz) ? BoxesRunTime.boxToBoolean((boolean)false) : BoxedUnit.UNIT;
        String[] copyMethods = (String[])ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps((Object[])clazz.getMethods()), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Method, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 != null && (A1 = A12).getName().startsWith("copy$default$") ? A1.getName() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Method x1) {
                Method method;
                Method method2 = x1;
                boolean bl = method2 != null && (method = method2).getName().startsWith("copy$default$");
                return bl;
            }
        }, ClassTag$.MODULE$.apply(String.class));
        return arity == copyMethods.length;
    }

    private Iterable<String> caseClassInfoInsideACompanionModule(Class<?> clazz, int arity) {
        IntRef counter = IntRef.create((int)0);
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps((Object[])clazz.getDeclaredFields()), (PartialFunction)new Serializable(counter, arity){
            private static final long serialVersionUID = 0L;
            private final IntRef counter$1;
            private final int arity$1;

            public final <A1 extends Field, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (this.counter$1.elem < this.arity$1) {
                    ++this.counter$1.elem;
                    object = A1.getName();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Field x1) {
                Field field = x1;
                boolean bl = this.counter$1.elem < this.arity$1;
                return bl;
            }
            {
                this.counter$1 = counter$1;
                this.arity$1 = arity$1;
            }
        }, ClassTag$.MODULE$.apply(String.class)));
    }

    private Map<String, Object> doGetCaseClassValues(Object target, Iterable<String> props) {
        Iterator product = ((Product)target).productIterator();
        Iterable tuples = (Iterable)props.map((Function1 & Serializable)y -> new Tuple2(y, product.next()));
        return tuples.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Tuple2<Object, Iterable<String>> checkCaseClassCache(Product p) {
        return (Tuple2)this.caseClassCache().getOrElseUpdate(p.getClass(), (Function0 & Serializable)() -> {
            Iterable<String> info;
            boolean isCaseClazz = MODULE$.checkCaseClass(p.getClass());
            Iterable<String> iterable = info = isCaseClazz ? MODULE$.doGetCaseClassInfo(p.getClass()) : null;
            if (!isCaseClazz) {
                isCaseClazz = MODULE$.isCaseClassInsideACompanionModule(p.getClass(), p.productArity());
                if (isCaseClazz) {
                    LogFactory.getLog(ScalaValueWriter.class).warn((Object)String.format("[%s] is detected as a case class in Java but not in Scala and thus its properties might be detected incorrectly - make sure the @ScalaSignature is available within the class bytecode and/or consider moving the case class from its companion object/module", p.getClass()));
                }
                info = isCaseClazz ? MODULE$.caseClassInfoInsideACompanionModule(p.getClass(), p.productArity()) : null;
            }
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isCaseClazz), info);
        });
    }

    public boolean isCaseClass(Product p) {
        return this.checkCaseClassCache(p)._1$mcZ$sp();
    }

    public Map<String, Object> caseClassValues(Product p) {
        return this.doGetCaseClassValues(p, (Iterable<String>)((Iterable)this.checkCaseClassCache(p)._2()));
    }

    private Tuple2<String, Method>[] checkJavaBeansCache(Object o) {
        return (Tuple2[])this.javaBeanCache().getOrElseUpdate(o.getClass(), (Function0 & Serializable)() -> MODULE$.javaBeansInfo(o.getClass()));
    }

    public boolean isJavaBean(Object value) {
        return !ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.checkJavaBeansCache(value)));
    }

    public Map<String, Object> javaBeanAsMap(Object value) {
        return this.javaBeansValues(value, this.checkJavaBeansCache(value));
    }

    private Tuple2<String, Method>[] javaBeansInfo(Class<?> clazz) {
        return (Tuple2[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps((Object[])Introspector.getBeanInfo(clazz).getPropertyDescriptors()), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends PropertyDescriptor, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                String string = A1.getName();
                String string2 = "class";
                Object object = (string == null ? string2 != null : !string.equals(string2)) && A1.getReadMethod() != null ? new Tuple2((Object)A1.getName(), (Object)A1.getReadMethod()) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(PropertyDescriptor x1) {
                PropertyDescriptor propertyDescriptor = x1;
                String string = propertyDescriptor.getName();
                String string2 = "class";
                boolean bl = (string == null ? string2 != null : !string.equals(string2)) && propertyDescriptor.getReadMethod() != null;
                return bl;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$);
    }

    private Map<String, Object> javaBeansValues(Object target, Tuple2<String, Method>[] info) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])info), (Function1 & Serializable)in -> new Tuple2(in._1(), ((Method)in._2()).invoke(target, new Object[0])), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final /* synthetic */ Method liftedTree1$1(Types.TypeApi t$1) {
        Method method;
        try {
            method = t$1.getClass().getMethod("decls", new Class[0]);
        }
        catch (Throwable throwable) {
            method = t$1.getClass().getMethod("declarations", new Class[0]);
        }
        return method;
    }

    private ReflectionUtils$() {
    }
}

