/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql.streaming;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.SparkSession;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class StructuredStreamingVersionLock$ {
    public static final StructuredStreamingVersionLock$ MODULE$ = new StructuredStreamingVersionLock$();
    private static final Log LOG = LogFactory.getLog(MODULE$.getClass());
    private static final Regex supported = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(2.[2-9].[0-9]|[3-9].[0-9].[0-9]).*"));

    public void checkCompatibility(SparkSession session) {
        try {
            BoxedUnit boxedUnit;
            Option option;
            String string = session.version();
            if (string != null && !(option = supported.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                String version = (String)((LinearSeqOps)option.get()).apply(0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)new StringBuilder(45).append("Running against supported version of Spark [").append(version).append("]").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new EsHadoopIllegalArgumentException(new StringBuilder(0).append("Spark version mismatch. Expected at least Spark version [2.2.0] ").append(new StringBuilder(86).append("but found [").append(session.version()).append("]. Spark Structured Streaming is a feature that is only supported on Spark ").toString()).append("[2.2.0] and up for this version of ES-Hadoop/Spark.").toString());
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
        catch (EsHadoopException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EsHadoopIllegalArgumentException("Could not determine the version of Spark for compatibility", t);
        }
    }

    private StructuredStreamingVersionLock$() {
    }
}

