/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.ssl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.common.ssl.SslConfigException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SslVerificationMode {
    NONE{

        @Override
        public boolean isHostnameVerificationEnabled() {
            return false;
        }

        @Override
        public boolean isCertificateVerificationEnabled() {
            return false;
        }
    }
    ,
    CERTIFICATE{

        @Override
        public boolean isHostnameVerificationEnabled() {
            return false;
        }

        @Override
        public boolean isCertificateVerificationEnabled() {
            return true;
        }
    }
    ,
    FULL{

        @Override
        public boolean isHostnameVerificationEnabled() {
            return true;
        }

        @Override
        public boolean isCertificateVerificationEnabled() {
            return true;
        }
    };

    private static final Map<String, SslVerificationMode> LOOKUP;

    public abstract boolean isHostnameVerificationEnabled();

    public abstract boolean isCertificateVerificationEnabled();

    private static Map<String, SslVerificationMode> buildLookup() {
        LinkedHashMap<String, SslVerificationMode> map = new LinkedHashMap<String, SslVerificationMode>(3);
        map.put("none", NONE);
        map.put("certificate", CERTIFICATE);
        map.put("full", FULL);
        return map;
    }

    public static SslVerificationMode parse(String value) {
        SslVerificationMode mode = LOOKUP.get(value.toLowerCase(Locale.ROOT));
        if (mode == null) {
            String allowedValues = LOOKUP.keySet().stream().collect(Collectors.joining(","));
            throw new SslConfigException("could not resolve ssl client verification mode, unknown value [" + value + "], recognised values are [" + allowedValues + "]");
        }
        return mode;
    }

    static {
        LOOKUP = Collections.unmodifiableMap(SslVerificationMode.buildLookup());
    }
}

