/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.memcached;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.support.RestUtils;

public class MemcachedRestRequest
extends RestRequest {
    private final RestRequest.Method method;
    private final String uri;
    private final byte[] uriBytes;
    private final int dataSize;
    private boolean binary;
    private final Map<String, String> params;
    private final String rawPath;
    private BytesReference data;
    private int opaque;
    private boolean quiet;

    public MemcachedRestRequest(RestRequest.Method method, String uri, byte[] uriBytes, int dataSize, boolean binary) {
        this.method = method;
        this.uri = uri;
        this.uriBytes = uriBytes;
        this.dataSize = dataSize;
        this.binary = binary;
        this.params = new HashMap<String, String>();
        int pathEndPos = uri.indexOf(63);
        if (pathEndPos < 0) {
            this.rawPath = uri;
        } else {
            this.rawPath = uri.substring(0, pathEndPos);
            RestUtils.decodeQueryString((String)uri, (int)(pathEndPos + 1), this.params);
        }
    }

    public RestRequest.Method method() {
        return this.method;
    }

    public String uri() {
        return this.uri;
    }

    public String rawPath() {
        return this.rawPath;
    }

    public byte[] getUriBytes() {
        return this.uriBytes;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public void setOpaque(int opaque) {
        this.opaque = opaque;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setData(BytesReference data) {
        this.data = data;
    }

    public boolean hasContent() {
        return this.data != null;
    }

    public BytesReference content() {
        return this.data;
    }

    public String header(String name) {
        return null;
    }

    public Iterable<Map.Entry<String, String>> headers() {
        return null;
    }

    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    public String param(String key) {
        return this.params.get(key);
    }

    public Map<String, String> params() {
        return this.params;
    }

    public String param(String key, String defaultValue) {
        String value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

