/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.memcached.netty;

import java.nio.charset.Charset;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.memcached.MemcachedRestRequest;
import org.elasticsearch.memcached.MemcachedTransportException;
import org.elasticsearch.memcached.common.Bytes;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;

public class MemcachedRestChannel
extends RestChannel {
    public static final ChannelBuffer CRLF = ChannelBuffers.copiedBuffer((CharSequence)"\r\n", (Charset)Charset.forName("US-ASCII"));
    private static final ChannelBuffer VALUE = ChannelBuffers.copiedBuffer((CharSequence)"VALUE ", (Charset)Charset.forName("US-ASCII"));
    private static final ChannelBuffer EXISTS = ChannelBuffers.copiedBuffer((CharSequence)"EXISTS\r\n", (Charset)Charset.forName("US-ASCII"));
    private static final ChannelBuffer NOT_FOUND = ChannelBuffers.copiedBuffer((CharSequence)"NOT_FOUND\r\n", (Charset)Charset.forName("US-ASCII"));
    private static final ChannelBuffer NOT_STORED = ChannelBuffers.copiedBuffer((CharSequence)"NOT_STORED\r\n", (Charset)Charset.forName("US-ASCII"));
    private static final ChannelBuffer STORED = ChannelBuffers.copiedBuffer((CharSequence)"STORED\r\n", (Charset)Charset.forName("US-ASCII"));
    private static final ChannelBuffer DELETED = ChannelBuffers.copiedBuffer((CharSequence)"DELETED\r\n", (Charset)Charset.forName("US-ASCII"));
    private static final ChannelBuffer END = ChannelBuffers.copiedBuffer((CharSequence)"END\r\n", (Charset)Charset.forName("US-ASCII"));
    private static final ChannelBuffer OK = ChannelBuffers.copiedBuffer((CharSequence)"OK\r\n", (Charset)Charset.forName("US-ASCII"));
    private static final ChannelBuffer ERROR = ChannelBuffers.copiedBuffer((CharSequence)"ERROR\r\n", (Charset)Charset.forName("US-ASCII"));
    private static final ChannelBuffer CLIENT_ERROR = ChannelBuffers.copiedBuffer((CharSequence)"CLIENT_ERROR\r\n", (Charset)Charset.forName("US-ASCII"));
    private final Channel channel;

    public MemcachedRestChannel(Channel channel, RestRequest request) {
        super(request, true);
        this.channel = channel;
    }

    public MemcachedRestRequest getMemcachedRequest() {
        return (MemcachedRestRequest)this.request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendResponse(RestResponse response) {
        if (this.getMemcachedRequest().isBinary()) {
            if (this.getMemcachedRequest().isQuiet() && response.status().getStatus() < 500) {
                return;
            }
            try {
                ChannelBuffer writeBuffer = ChannelBuffers.dynamicBuffer((int)(24 + this.getMemcachedRequest().getUriBytes().length + response.content().length() + 12));
                writeBuffer.writeByte(129);
                if (this.request.method() == RestRequest.Method.GET) {
                    writeBuffer.writeByte(0);
                } else if (this.request.method() == RestRequest.Method.POST) {
                    if (this.getMemcachedRequest().isQuiet()) {
                        writeBuffer.writeByte(17);
                    } else {
                        writeBuffer.writeByte(1);
                    }
                } else if (this.request.method() == RestRequest.Method.DELETE) {
                    writeBuffer.writeByte(4);
                }
                int keyLength = this.request.method() == RestRequest.Method.GET ? (int)this.getMemcachedRequest().getUriBytes().length : 0;
                writeBuffer.writeShort(keyLength);
                int extrasLength = this.request.method() == RestRequest.Method.GET ? 4 : 0;
                writeBuffer.writeByte(extrasLength);
                writeBuffer.writeByte(0);
                if (response.status().getStatus() >= 500) {
                    writeBuffer.writeShort(10);
                } else {
                    writeBuffer.writeShort(0);
                }
                int dataLength = this.request.method() == RestRequest.Method.GET ? response.content().length() : 0;
                writeBuffer.writeInt(dataLength + keyLength + extrasLength);
                writeBuffer.writeInt(this.getMemcachedRequest().getOpaque());
                writeBuffer.writeLong(0L);
                if (extrasLength > 0) {
                    writeBuffer.writeShort(0);
                    writeBuffer.writeShort(0);
                }
                if (keyLength > 0) {
                    writeBuffer.writeBytes(this.getMemcachedRequest().getUriBytes());
                }
                ChannelFutureListener releaseContentListener = null;
                if (dataLength > 0) {
                    ChannelBuffer buf = ChannelBuffers.wrappedBuffer((byte[])response.content().toBytes(), (int)response.content().arrayOffset(), (int)response.content().length());
                    writeBuffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{writeBuffer, buf});
                }
                ChannelFuture future = this.channel.write((Object)writeBuffer);
                if (releaseContentListener == null) return;
                future.addListener(releaseContentListener);
                return;
            }
            catch (Exception e) {
                throw new MemcachedTransportException("Failed to write response", e);
            }
        }
        if (response.status().getStatus() >= 500) {
            this.channel.write((Object)ERROR.duplicate());
            return;
        }
        if (this.request.method() == RestRequest.Method.POST) {
            this.channel.write((Object)STORED.duplicate());
            return;
        }
        if (this.request.method() == RestRequest.Method.DELETE) {
            this.channel.write((Object)DELETED.duplicate());
            return;
        }
        try {
            ChannelBuffer writeBuffer = ChannelBuffers.dynamicBuffer((int)(response.content().length() + 512));
            writeBuffer.writeBytes(VALUE.duplicate());
            BytesRef bytesRef = new BytesRef((CharSequence)this.request.uri());
            writeBuffer.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
            writeBuffer.writeByte(32);
            writeBuffer.writeByte(48);
            writeBuffer.writeByte(32);
            writeBuffer.writeBytes(Bytes.itoa(response.content().length()));
            writeBuffer.writeByte(13);
            writeBuffer.writeByte(10);
            writeBuffer.writeBytes(response.content().toBytes(), 0, response.content().length());
            writeBuffer.writeByte(13);
            writeBuffer.writeByte(10);
            writeBuffer.writeBytes(END.duplicate());
            this.channel.write((Object)writeBuffer);
            return;
        }
        catch (Exception e) {
            throw new MemcachedTransportException("Failed to write 'get' response", e);
        }
    }
}

